// Hygx cubic filter function for B=0 and C=1

#version 430

#define SIGN(x)           ( int(x >= 0) - int(x < 0) )  // GLSL sign(0) gives 0 i.s.o 1

// #defines and globals
#define POW2(x)	((x)*(x))
#define POW3(x)	((x)*(x)*(x))
#define POW4(x)	((x)*(x)*(x)*(x))
#define POW5(x)	((x)*(x)*(x)*(x)*(x))
#define POW6(x)	((x)*(x)*(x)*(x)*(x)*(x))
#define POW7(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x))
#define POW8(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x)*(x))

float X2, X3, X4, X5, X6, X7, X8;
float T2, T3, T4, T5, T6, T7, T8;
float Y2, Y3, Y4, Y5, Y6, Y7, Y8;

#pragma region Base integral Cell expressions
// generated with cubicMitchellBC-generic-mm113.nb

float i2cell00_B03C03(float x, float t, float y0) {
    return
    (POW3(2 + x)*(T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 245*X5) + 10*(6 + 7*x)*POW3(2 + y0)*(6 + 7*y0) + 32*t*(-2 + 3*x + 7*X2)*POW2(2 + y0)*(8 + 7*y0) + 160*T3*X4*(12 + 7*y0) + 8*T2*(4 - 6*x + 6*X2 + 35*X3)*(20 + 24*y0 + 7*Y2)))/51840.;
}
float i2cell10_B03C03(float x, float t, float y0) {
    return
    (-(T4*(252 - 896*X5 + 1440*X7 + 735*X8)) - 10*(-36 - 64*x + 48*X3 + 21*X4)*POW3(2 + y0)*(6 + 7*y0) - 32*t*(14 - 40*X2 + 45*X4 + 21*X5)*POW2(2 + y0)*(8 + 7*y0) - 160*T3*(-4 + 6*X2 + 3*X3)*X4*(12 + 7*y0) - 8*T2*(-30 - 160*X3 + 216*X5 + 105*X6)*(20 + 24*y0 + 7*Y2))/51840.;
}
float i2cell20_B03C03(float x, float t, float y0) {
    return
    (T4*(-252 + 896*X5 - 1440*X7 + 735*X8) + 10*(36 + 64*x - 48*X3 + 21*X4)*POW3(2 + y0)*(6 + 7*y0) + 32*t*(-14 + 40*X2 - 45*X4 + 21*X5)*POW2(2 + y0)*(8 + 7*y0) + 160*T3*(4 - 6*X2 + 3*X3)*X4*(12 + 7*y0) + 8*T2*(30 + 160*X3 - 216*X5 + 105*X6)*(20 + 24*y0 + 7*Y2))/51840.;
}
float i2cell30_B03C03(float x, float t, float y0) {
    return
    (-(T4*(248 - 1792*X5 + 2800*X6 - 1440*X7 + 245*X8)) - 10*(-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*POW3(2 + y0)*(6 + 7*y0) - 32*t*POW3(-2 + x)*(-2 - 3*x + 7*X2)*POW2(2 + y0)*(8 + 7*y0) - 160*T3*POW3(-2 + x)*X4*(12 + 7*y0) - 8*T2*(-28 - 320*X3 + 450*X4 - 216*X5 + 35*X6)*(20 + 24*y0 + 7*Y2))/51840.;
}
float i2cell01_B03C03(float x, float t, float y0) {
    return
    -(POW3(2 + x)*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 245*X5) + 480*T3*X4*(4 + 7*y0) + 24*T2*(4 - 6*x + 6*X2 + 35*X3)*y0*(8 + 7*y0) + 32*t*(-2 + 3*x + 7*X2)*(-16 + 36*Y2 + 21*Y3) + 10*(6 + 7*x)*(-36 - 64*y0 + 48*Y3 + 21*Y4)))/51840.;
}
float i2cell11_B03C03(float x, float t, float y0) {
    return
    (3*T4*(252 - 896*X5 + 1440*X7 + 735*X8) + 480*T3*(-4 + 6*X2 + 3*X3)*X4*(4 + 7*y0) + 24*T2*(-30 - 160*X3 + 216*X5 + 105*X6)*y0*(8 + 7*y0) + 32*t*(14 - 40*X2 + 45*X4 + 21*X5)*(-16 + 36*Y2 + 21*Y3) + 10*(-36 - 64*x + 48*X3 + 21*X4)*(-36 - 64*y0 + 48*Y3 + 21*Y4))/51840.;
}
float i2cell21_B03C03(float x, float t, float y0) {
    return
    (-3*T4*(-252 + 896*X5 - 1440*X7 + 735*X8) - 480*T3*(4 - 6*X2 + 3*X3)*X4*(4 + 7*y0) - 24*T2*(30 + 160*X3 - 216*X5 + 105*X6)*y0*(8 + 7*y0) - 32*t*(-14 + 40*X2 - 45*X4 + 21*X5)*(-16 + 36*Y2 + 21*Y3) - 10*(36 + 64*x - 48*X3 + 21*X4)*(-36 - 64*y0 + 48*Y3 + 21*Y4))/51840.;
}
float i2cell31_B03C03(float x, float t, float y0) {
    return
    (3*T4*(248 - 1792*X5 + 2800*X6 - 1440*X7 + 245*X8) + 480*T3*POW3(-2 + x)*X4*(4 + 7*y0) + 24*T2*(-28 - 320*X3 + 450*X4 - 216*X5 + 35*X6)*y0*(8 + 7*y0) + 32*t*POW3(-2 + x)*(-2 - 3*x + 7*X2)*(-16 + 36*Y2 + 21*Y3) + 10*(-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*(-36 - 64*y0 + 48*Y3 + 21*Y4))/51840.;
}
float i2cell02_B03C03(float x, float t, float y0) {
    return
    (POW3(2 + x)*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 245*X5) + 24*T2*(4 - 6*x + 6*X2 + 35*X3)*y0*(-8 + 7*y0) + 480*T3*X4*(-4 + 7*y0) + 32*t*(-2 + 3*x + 7*X2)*(16 - 36*Y2 + 21*Y3) + 10*(6 + 7*x)*(36 + 64*y0 - 48*Y3 + 21*Y4)))/51840.;
}
float i2cell12_B03C03(float x, float t, float y0) {
    return
    (-3*T4*(252 - 896*X5 + 1440*X7 + 735*X8) - 24*T2*(-30 - 160*X3 + 216*X5 + 105*X6)*y0*(-8 + 7*y0) - 480*T3*(-4 + 6*X2 + 3*X3)*X4*(-4 + 7*y0) - 32*t*(14 - 40*X2 + 45*X4 + 21*X5)*(16 - 36*Y2 + 21*Y3) - 10*(-36 - 64*x + 48*X3 + 21*X4)*(36 + 64*y0 - 48*Y3 + 21*Y4))/51840.;
}
float i2cell22_B03C03(float x, float t, float y0) {
    return
    (3*T4*(-252 + 896*X5 - 1440*X7 + 735*X8) + 24*T2*(30 + 160*X3 - 216*X5 + 105*X6)*y0*(-8 + 7*y0) + 480*T3*(4 - 6*X2 + 3*X3)*X4*(-4 + 7*y0) + 32*t*(-14 + 40*X2 - 45*X4 + 21*X5)*(16 - 36*Y2 + 21*Y3) + 10*(36 + 64*x - 48*X3 + 21*X4)*(36 + 64*y0 - 48*Y3 + 21*Y4))/51840.;
}
float i2cell32_B03C03(float x, float t, float y0) {
    return
    (-3*T4*(248 - 1792*X5 + 2800*X6 - 1440*X7 + 245*X8) - 24*T2*(-28 - 320*X3 + 450*X4 - 216*X5 + 35*X6)*y0*(-8 + 7*y0) - 480*T3*POW3(-2 + x)*X4*(-4 + 7*y0) - 32*t*POW3(-2 + x)*(-2 - 3*x + 7*X2)*(16 - 36*Y2 + 21*Y3) - 10*(-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*(36 + 64*y0 - 48*Y3 + 21*Y4))/51840.;
}
float i2cell03_B03C03(float x, float t, float y0) {
    return
    -(POW3(2 + x)*(T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 245*X5) + 160*T3*X4*(-12 + 7*y0) + 32*t*(-2 + 3*x + 7*X2)*POW2(-2 + y0)*(-8 + 7*y0) + 8*T2*(4 - 6*x + 6*X2 + 35*X3)*(20 - 24*y0 + 7*Y2) + 10*(6 + 7*x)*(-24 - 128*y0 + 120*Y2 - 48*Y3 + 7*Y4)))/51840.;
}
float i2cell13_B03C03(float x, float t, float y0) {
    return
    (T4*(252 - 896*X5 + 1440*X7 + 735*X8) + 160*T3*(-4 + 6*X2 + 3*X3)*X4*(-12 + 7*y0) + 32*t*(14 - 40*X2 + 45*X4 + 21*X5)*POW2(-2 + y0)*(-8 + 7*y0) + 8*T2*(-30 - 160*X3 + 216*X5 + 105*X6)*(20 - 24*y0 + 7*Y2) + 10*(-36 - 64*x + 48*X3 + 21*X4)*(-24 - 128*y0 + 120*Y2 - 48*Y3 + 7*Y4))/51840.;
}
float i2cell23_B03C03(float x, float t, float y0) {
    return
    (-(T4*(-252 + 896*X5 - 1440*X7 + 735*X8)) - 160*T3*(4 - 6*X2 + 3*X3)*X4*(-12 + 7*y0) - 32*t*(-14 + 40*X2 - 45*X4 + 21*X5)*POW2(-2 + y0)*(-8 + 7*y0) - 8*T2*(30 + 160*X3 - 216*X5 + 105*X6)*(20 - 24*y0 + 7*Y2) - 10*(36 + 64*x - 48*X3 + 21*X4)*(-24 - 128*y0 + 120*Y2 - 48*Y3 + 7*Y4))/51840.;
}
float i2cell33_B03C03(float x, float t, float y0) {
    return
    (T4*(248 - 1792*X5 + 2800*X6 - 1440*X7 + 245*X8) + 160*T3*POW3(-2 + x)*X4*(-12 + 7*y0) + 32*t*POW3(-2 + x)*(-2 - 3*x + 7*X2)*POW2(-2 + y0)*(-8 + 7*y0) + 8*T2*(-28 - 320*X3 + 450*X4 - 216*X5 + 35*X6)*(20 - 24*y0 + 7*Y2) + 10*(-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*(-24 - 128*y0 + 120*Y2 - 48*Y3 + 7*Y4))/51840.;
}

#pragma endregion 

#pragma region horizontal cell borders constant expressions
// generated with cubicMitchellBC-generic-mm113.nb

float HygxBorder04_B03C03(float t, float y0) {
    return
    -(POW6(-2 - 2*t + y0)*(4 + 4*T2 + 12*t*(-2 + y0) + 12*y0 - 7*Y2))/(51840.*POW4(t));
}
float HygxBorder14_B03C03(float t, float y0) {
    return
    (-252*T8 + 96*t*POW6(-2 + y0)*y0 - 448*T5*POW2(-2 + y0)*(-8 + 7*y0) + 360*T4*POW3(-2 + y0)*(-6 + 7*y0) - 128*T3*POW4(-2 + y0)*(-4 + 7*y0) - 3*POW7(-2 + y0)*(2 + 7*y0) + 240*T6*(20 - 24*y0 + 7*Y2))/(51840.*POW4(t));
}
float HygxBorder24_B03C03(float t, float y0) {
    return
    (-252*T8 + 96*t*POW6(-2 + y0)*y0 - 448*T5*POW2(-2 + y0)*(-8 + 7*y0) + 360*T4*POW3(-2 + y0)*(-6 + 7*y0) - 128*T3*POW4(-2 + y0)*(-4 + 7*y0) + 3*POW7(-2 + y0)*(2 + 7*y0) + 240*T6*(20 - 24*y0 + 7*Y2))/(51840.*POW4(t));
}
float HygxBorder34_B03C03(float t, float y0) {
    return
    -(248*T8 + 96*t*POW6(-2 + y0)*y0 + 512*T5*POW2(-2 + y0)*(-8 + 7*y0) - 240*T4*POW3(-2 + y0)*(-6 + 7*y0) + 256*T3*POW4(-2 + y0)*(-4 + 7*y0) + 80*T2*POW5(-2 + y0)*(-2 + 7*y0) + POW7(-2 + y0)*(2 + 7*y0) - 224*T6*(20 - 24*y0 + 7*Y2))/(51840.*POW4(t));
}
float HygxBorder03_B03C03(float t, float y0) {
    return
    (POW6(-1 - 2*t + y0)*(1 + 4*T2 + 12*t*(-1 + y0) + 6*y0 - 7*Y2))/(12960.*POW4(t));
}
float HygxBorder13_B03C03(float t, float y0) {
    return
    (252*T8 - 96*t*POW6(-1 + y0)*y0 + 448*T5*POW2(-1 + y0)*(-4 + 7*y0) - 360*T4*POW3(-1 + y0)*(-3 + 7*y0) + 128*T3*POW4(-1 + y0)*(-2 + 7*y0) + 3*POW7(-1 + y0)*(1 + 7*y0) - 240*T6*(5 - 12*y0 + 7*Y2))/(12960.*POW4(t));
}
float HygxBorder23_B03C03(float t, float y0) {
    return
    (252*T8 - 96*t*POW6(-1 + y0)*y0 + 448*T5*POW2(-1 + y0)*(-4 + 7*y0) - 360*T4*POW3(-1 + y0)*(-3 + 7*y0) + 128*T3*POW4(-1 + y0)*(-2 + 7*y0) - 3*POW7(-1 + y0)*(1 + 7*y0) - 240*T6*(5 - 12*y0 + 7*Y2))/(12960.*POW4(t));
}
float HygxBorder33_B03C03(float t, float y0) {
    return
    (248*T8 + 96*t*POW6(-1 + y0)*y0 + 512*T5*POW2(-1 + y0)*(-4 + 7*y0) - 240*T4*POW3(-1 + y0)*(-3 + 7*y0) + 256*T3*POW4(-1 + y0)*(-2 + 7*y0) + 80*T2*POW5(-1 + y0)*(-1 + 7*y0) + POW7(-1 + y0)*(1 + 7*y0) - 224*T6*(5 - 12*y0 + 7*Y2))/(12960.*POW4(t));
}
float HygxBorder02_B03C03(float t, float y0) {
    return
    -(POW7(2*t - y0)*(2*t + 7*y0))/(8640.*POW4(t));
}
float HygxBorder12_B03C03(float t, float y0) {
    return
    -(252*T8 - 1680*T6*Y2 + 3136*T5*Y3 - 2520*T4*Y4 + 896*T3*Y5 - 96*t*Y7 + 21*Y8)/(8640.*POW4(t));
}
float HygxBorder22_B03C03(float t, float y0) {
    return
    (-252*T8 + 1680*T6*Y2 - 3136*T5*Y3 + 2520*T4*Y4 - 896*T3*Y5 + 96*t*Y7 + 21*Y8)/(8640.*POW4(t));
}
float HygxBorder32_B03C03(float t, float y0) {
    return
    -(248*T8 - 1568*T6*Y2 + 3584*T5*Y3 - 1680*T4*Y4 + 1792*T3*Y5 + 560*T2*Y6 + 96*t*Y7 + 7*Y8)/(8640.*POW4(t));
}
float HygxBorder01_B03C03(float t, float y0) {
    return
    (POW6(1 - 2*t + y0)*(1 + 4*T2 - 6*y0 + 12*t*(1 + y0) - 7*Y2))/(12960.*POW4(t));
}
float HygxBorder11_B03C03(float t, float y0) {
    return
    (252*T8 - 96*t*y0*POW6(1 + y0) + 3*POW7(1 + y0)*(-1 + 7*y0) + 128*T3*POW4(1 + y0)*(2 + 7*y0) - 360*T4*POW3(1 + y0)*(3 + 7*y0) + 448*T5*POW2(1 + y0)*(4 + 7*y0) - 240*T6*(5 + 12*y0 + 7*Y2))/(12960.*POW4(t));
}
float HygxBorder21_B03C03(float t, float y0) {
    return
    (252*T8 - 96*t*y0*POW6(1 + y0) - 3*POW7(1 + y0)*(-1 + 7*y0) + 128*T3*POW4(1 + y0)*(2 + 7*y0) - 360*T4*POW3(1 + y0)*(3 + 7*y0) + 448*T5*POW2(1 + y0)*(4 + 7*y0) - 240*T6*(5 + 12*y0 + 7*Y2))/(12960.*POW4(t));
}
float HygxBorder31_B03C03(float t, float y0) {
    return
    (248*T8 + 96*t*y0*POW6(1 + y0) + POW7(1 + y0)*(-1 + 7*y0) + 80*T2*POW5(1 + y0)*(1 + 7*y0) + 256*T3*POW4(1 + y0)*(2 + 7*y0) - 240*T4*POW3(1 + y0)*(3 + 7*y0) + 512*T5*POW2(1 + y0)*(4 + 7*y0) - 224*T6*(5 + 12*y0 + 7*Y2))/(12960.*POW4(t));
}
float HygxBorder00_B03C03(float t, float y0) {
    return
    -(POW6(2 - 2*t + y0)*(4 + 4*T2 - 12*y0 + 12*t*(2 + y0) - 7*Y2))/(51840.*POW4(t));
}
float HygxBorder10_B03C03(float t, float y0) {
    return
    (-252*T8 + 96*t*y0*POW6(2 + y0) - 3*POW7(2 + y0)*(-2 + 7*y0) - 128*T3*POW4(2 + y0)*(4 + 7*y0) + 360*T4*POW3(2 + y0)*(6 + 7*y0) - 448*T5*POW2(2 + y0)*(8 + 7*y0) + 240*T6*(20 + 24*y0 + 7*Y2))/(51840.*POW4(t));
}
float HygxBorder20_B03C03(float t, float y0) {
    return
    (-252*T8 + 96*t*y0*POW6(2 + y0) + 3*POW7(2 + y0)*(-2 + 7*y0) - 128*T3*POW4(2 + y0)*(4 + 7*y0) + 360*T4*POW3(2 + y0)*(6 + 7*y0) - 448*T5*POW2(2 + y0)*(8 + 7*y0) + 240*T6*(20 + 24*y0 + 7*Y2))/(51840.*POW4(t));
}
float HygxBorder30_B03C03(float t, float y0) {
    return
    -(248*T8 + 96*t*y0*POW6(2 + y0) + POW7(2 + y0)*(-2 + 7*y0) + 80*T2*POW5(2 + y0)*(2 + 7*y0) + 256*T3*POW4(2 + y0)*(4 + 7*y0) - 240*T4*POW3(2 + y0)*(6 + 7*y0) + 512*T5*POW2(2 + y0)*(8 + 7*y0) - 224*T6*(20 + 24*y0 + 7*Y2))/(51840.*POW4(t));
}

#pragma endregion 

#pragma region Hygx_cubic
float Hygx_cubic_B03C03(float xIn, float t, float y0)
{
    float x = min(xIn, 1.9999);   // clip x against right border of filter footprint
                                // such that value at x==2 is being repeated for all x>2
                                // TODO: change 1.9999 into 2.0
    float gx = t * x + y0;  // y=g(x) defines the (diagonal) line where integration is along

    if (x <= -2.0 + 0.0001) return 0; // to the west of all cells, obtaining weight = 0
    // Next "early exit" can safely be omitted.
    if (t >= 0 && gx < -2) return 0; // to the south of all cells, only with positive tangent, obtains weight = 0

    // first, evaluate base integral Hygx-cells for the 16 cell area's
    // ---------------------------------------------------------------
    float wBase = 0; // weight of cell integral (with constants for vertical line x == -2,-1,0,1,2)

    // globals; made powers of x and t globals to reduce code redundancy for now.
    // Compute these powers here i.s.o. in each of the cell functions
    X2 = x*x; X3 = X2*x; X4 = X3*x; X5 = X4*x; X6 = X5*x; X7 = X6*x; X8 = X7*x;
    T2 = t*t; T3 = T2*t; T4 = T3*t; T5 = T4*t; T6 = T5*t; T7 = T6*t; T8 = T7*t;
    Y2 = y0*y0; Y3 = Y2*y0; Y4 = Y3*y0; Y5 = Y4*y0; Y6 = Y5*y0; Y7 = Y6*y0; Y8 = Y7*y0;

    // NOTE: ONLY THE BASE FUNCTIONS WITHIN THE AA-FILTER FOOTPRINT NEED TO BE IMPLEMENTED
    // VERTICAL CLIPPING IN WtEdgeAB ensures functions outside are not required.
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (gx >= +1) { wBase = i2cell03_B03C03(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell02_B03C03(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell01_B03C03(x, t, y0); }
        else               { wBase = i2cell00_B03C03(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (gx >= +1) { wBase = i2cell13_B03C03(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell12_B03C03(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell11_B03C03(x, t, y0); }
        else               { wBase = i2cell10_B03C03(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (gx >= +1) { wBase = i2cell23_B03C03(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell22_B03C03(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell21_B03C03(x, t, y0); }
        else               { wBase = i2cell20_B03C03(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (gx >= +1) { wBase = i2cell33_B03C03(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell32_B03C03(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell31_B03C03(x, t, y0); }
        else               { wBase = i2cell30_B03C03(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }

    // second, add diagonal "row"-constants ALLONG TANGENT LINE for (overlapping) area's
    // ---------------------------------------------------------------------------------

    // Compute integral constants at horizontal cell piecewise discontinuities at HygxBorder[xy]
    // Where [xy] indicate the bottom border of cell[xy].
    // 2D overlapping area's of constants are defined by 
    // - horizontal range   where x is restricted to -2 < x < +2
    // - vertical range     where gx is restricted
    // - diagonal range     where y0 is restricted

    float wConst = 0;
    int st = SIGN(t);

    // HygxBorder*4: Only needed for negative tangent; below horizontal line: g(x) = +2
    if (t < 0 && gx <= 2.0001)
    {
        // Border04 for negative t:  y0 <= 2 + t  &&  y0 > 2 + 2t (since st=-1, conditions can be simplified)
        if      ( ((2 +   t - y0)*st <= 0)  &&  ((2 + 2*t - y0)*st > 0) ) wConst += HygxBorder04_B03C03(t, y0);
        else if ( ((2       - y0)*st <= 0)  &&  ((2 +   t - y0)*st > 0) ) wConst += HygxBorder14_B03C03(t, y0);
        else if ( ((2 -   t - y0)*st <= 0)  &&  ((2       - y0)*st > 0) ) wConst += HygxBorder24_B03C03(t, y0);
        else if (/*(2 - 2*t - y0)*st <= 0 */    ((2 -   t - y0)*st > 0) ) wConst += HygxBorder34_B03C03(t, y0);
    }
    // HygxBorder*3: For positive and negative tangent; above respectively below horizontal line: g(x) = +1
    if ( (t >= 0 && gx >= 1) || (t < 0 && gx < 1) )
    {
        // Border03 positive t: y0 >= 1 + t  &&  y0 < 1 + 2t, negative t: y0 <= 1 + t  &&  y0 > 1 + 2t
        if      ( ((1 +   t - y0)*st <= 0)  &&  ((1 + 2*t - y0)*st > 0) ) wConst += HygxBorder03_B03C03(t, y0);
        else if ( ((1       - y0)*st <= 0)  &&  ((1 +   t - y0)*st > 0) ) wConst += HygxBorder13_B03C03(t, y0);
        else if ( ((1 -   t - y0)*st <= 0)  &&  ((1       - y0)*st > 0) ) wConst += HygxBorder23_B03C03(t, y0);
        else if (/*(1 - 2*t - y0)*st <= 0 */    ((1 -   t - y0)*st > 0) ) wConst += HygxBorder33_B03C03(t, y0);
    }
    // HygxBorder*2: For positive and negative tangent; above respectively below horizontal line: g(x) = 0
    if ( (t >= 0 && gx >= 0) || (t < 0 && gx < 0) )
    {
        // Border02 positive t: y0 >= 0 + t  &&  y0 < 0 + 2t, negative t: y0 <= 0 + t  &&  y0 > 0 + 2t
        if      ( ((0 +   t - y0)*st <= 0)  &&  ((0 + 2*t - y0)*st > 0) ) wConst += HygxBorder02_B03C03(t, y0);
        else if ( ((0       - y0)*st <= 0)  &&  ((0 +   t - y0)*st > 0) ) wConst += HygxBorder12_B03C03(t, y0);
        else if ( ((0 -   t - y0)*st <= 0)  &&  ((0       - y0)*st > 0) ) wConst += HygxBorder22_B03C03(t, y0);
        else if (/*(0 - 2*t - y0)*st <= 0 */    ((0 -   t - y0)*st > 0) ) wConst += HygxBorder32_B03C03(t, y0);
    }
    // HygxBorder*1: For positive and negative tangent; above respectively below horizontal line: g(x) = -1
    if ( (t >= 0 && gx >= -1) || (t < 0 && gx < -1) )
    {
        // Border01 positive t: y0 >= -1 + t  &&  y0 < -1 + 2t, negative t: y0 <= -1 + t  &&  y0 > -1 + 2t
        if      ( ((-1 +   t - y0)*st <= 0)  &&  ((-1 + 2*t - y0)*st > 0) ) wConst += HygxBorder01_B03C03(t, y0);
        else if ( ((-1       - y0)*st <= 0)  &&  ((-1 +   t - y0)*st > 0) ) wConst += HygxBorder11_B03C03(t, y0);
        else if ( ((-1 -   t - y0)*st <= 0)  &&  ((-1       - y0)*st > 0) ) wConst += HygxBorder21_B03C03(t, y0);
        else if (/*(-1 - 2*t - y0)*st <= 0 */    ((-1 -   t - y0)*st > 0) ) wConst += HygxBorder31_B03C03(t, y0);
    }
    // HygxBorder*0: Only needed for positive tangent; above horizontal line: g(x) = -2
    if ( t > 0 && gx >= -2 )
    {
        // Border00 positive t: y0 >= -2 + t  &&  y0 < -2 + 2t (since st=1, conditions can be simplified)
        if      ( ((-2 +   t - y0)*st <= 0)  &&  ((-2 + 2*t - y0)*st > 0) ) wConst += HygxBorder00_B03C03(t, y0);
        else if ( ((-2       - y0)*st <= 0)  &&  ((-2 +   t - y0)*st > 0) ) wConst += HygxBorder10_B03C03(t, y0);
        else if ( ((-2 -   t - y0)*st <= 0)  &&  ((-2       - y0)*st > 0) ) wConst += HygxBorder20_B03C03(t, y0);
        else if (/*(-2 - 2*t - y0)*st <= 0 */    ((-2 -   t - y0)*st > 0) ) wConst += HygxBorder30_B03C03(t, y0);
    }

    float weight = wBase - wConst * st;
    return weight;
}
#pragma endregion

// ============================================================================

#pragma region CubicStrong Hyx polynomials
// When tangent=0, i.e. exact horizontal edge. Robust against xa==xb

float HyxCell00_B03C03(float x, float y) {
    return
    (POW3(2 + x)*(6 + 7*x)*POW3(2 + y)*(6 + 7*y))/5184.;
}
float HyxCell10_B03C03(float x, float y) {
    return
    -((-36 - 64*x + 48*X3 + 21*X4)*POW3(2 + y)*(6 + 7*y))/5184.;
}
float HyxCell20_B03C03(float x, float y) {
    return
    ((36 + 64*x - 48*X3 + 21*X4)*POW3(2 + y)*(6 + 7*y))/5184.;
}
float HyxCell30_B03C03(float x, float y) {
    return
    -((-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*POW3(2 + y)*(6 + 7*y))/5184.;
}
float HyxCell01_B03C03(float x, float y) {
    return
    -(POW3(2 + x)*(6 + 7*x)*(-36 - 64*y + 48*Y3 + 21*Y4))/5184.;
}
float HyxCell11_B03C03(float x, float y) {
    return
    ((-36 - 64*x + 48*X3 + 21*X4)*(-36 - 64*y + 48*Y3 + 21*Y4))/5184.;
}
float HyxCell21_B03C03(float x, float y) {
    return
    -((36 + 64*x - 48*X3 + 21*X4)*(-36 - 64*y + 48*Y3 + 21*Y4))/5184.;
}
float HyxCell31_B03C03(float x, float y) {
    return
    ((-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*(-36 - 64*y + 48*Y3 + 21*Y4))/5184.;
}
float HyxCell02_B03C03(float x, float y) {
    return
    (POW3(2 + x)*(6 + 7*x)*(36 + 64*y - 48*Y3 + 21*Y4))/5184.;
}
float HyxCell12_B03C03(float x, float y) {
    return
    -((-36 - 64*x + 48*X3 + 21*X4)*(36 + 64*y - 48*Y3 + 21*Y4))/5184.;
}
float HyxCell22_B03C03(float x, float y) {
    return
    ((36 + 64*x - 48*X3 + 21*X4)*(36 + 64*y - 48*Y3 + 21*Y4))/5184.;
}
float HyxCell32_B03C03(float x, float y) {
    return
    -((-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*(36 + 64*y - 48*Y3 + 21*Y4))/5184.;
}
float HyxCell03_B03C03(float x, float y) {
    return
    -(POW3(2 + x)*(6 + 7*x)*(-24 - 128*y + 120*Y2 - 48*Y3 + 7*Y4))/5184.;
}
float HyxCell13_B03C03(float x, float y) {
    return
    ((-36 - 64*x + 48*X3 + 21*X4)*(-24 - 128*y + 120*Y2 - 48*Y3 + 7*Y4))/5184.;
}
float HyxCell23_B03C03(float x, float y) {
    return
    -((36 + 64*x - 48*X3 + 21*X4)*(-24 - 128*y + 120*Y2 - 48*Y3 + 7*Y4))/5184.;
}
float HyxCell33_B03C03(float x, float y) {
    return
    ((-24 - 128*x + 120*X2 - 48*X3 + 7*X4)*(-24 - 128*y + 120*Y2 - 48*Y3 + 7*Y4))/5184.;
}


float Hyx_cubicB03C03(float x, float y)
{
	// globals; gives more readable cell functions and reduces redundancy
	X2 = x*x; X3 = X2*x; X4 = X3*x;
    Y2 = y*y; Y3 = Y2*y; Y4 = Y3*y;
    float w = 0;
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (y >= +1) w = HyxCell03_B03C03(x, y);
        else if (y >=  0) w = HyxCell02_B03C03(x, y);
        else if (y >= -1) w = HyxCell01_B03C03(x, y);
        else              w = HyxCell00_B03C03(x, y);
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (y >= +1) w = HyxCell13_B03C03(x, y);
        else if (y >=  0) w = HyxCell12_B03C03(x, y);
        else if (y >= -1) w = HyxCell11_B03C03(x, y);
        else              w = HyxCell10_B03C03(x, y);
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (y >= +1) w = HyxCell23_B03C03(x, y);
        else if (y >=  0) w = HyxCell22_B03C03(x, y);
        else if (y >= -1) w = HyxCell21_B03C03(x, y);
        else              w = HyxCell20_B03C03(x, y);
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (y >= +1) w = HyxCell33_B03C03(x, y);
        else if (y >=  0) w = HyxCell32_B03C03(x, y);
        else if (y >= -1) w = HyxCell31_B03C03(x, y);
        else              w = HyxCell30_B03C03(x, y);
    }
    return w;
}
#pragma endregion
