// Hygx cubic filter function for B=0 and C=1

#version 430

#define SIGN(x)           ( int(x >= 0) - int(x < 0) )  // GLSL sign(0) gives 0 i.s.o 1

// #defines and globals
#define POW2(x)	((x)*(x))
#define POW3(x)	((x)*(x)*(x))
#define POW4(x)	((x)*(x)*(x)*(x))
#define POW5(x)	((x)*(x)*(x)*(x)*(x))
#define POW6(x)	((x)*(x)*(x)*(x)*(x)*(x))
#define POW7(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x))
#define POW8(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x)*(x))

float X2, X3, X4, X5, X6, X7, X8;
float T2, T3, T4, T5, T6, T7, T8;
float Y2, Y3, Y4, Y5, Y6, Y7, Y8;

#pragma region Base integral Cell expressions
// generated in cubicMitchell-mm113_4x4cellsAproach.nb

float i2cell00_B0C05(float x, float t, float y0) {
    return
    (POW3(2 + x)*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 168*t*(-2 + 3*x + 12*X2)*(1 + y0)*POW2(2 + y0) + 70*(2 + 3*x)*POW3(2 + y0)*(2 + 3*y0) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(5 + 3*y0) + 840*T2*X3*(8 + 10*y0 + 3*Y2)))/40320.;
}
float i2cell10_B0C05(float x, float t, float y0) {
    return
    (-9*T4*(84 - 112*X5 + 200*X7 + 105*X8) - 168*t*(14 - 60*X2 + 75*X4 + 36*X5)*(1 + y0)*POW2(2 + y0) - 70*(-12 - 24*x + 20*X3 + 9*X4)*POW3(2 + y0)*(2 + 3*y0) - 16*T3*(-31 - 105*X4 + 175*X6 + 90*X7)*(5 + 3*y0) - 840*T2*X3*(-4 + 6*X2 + 3*X3)*(8 + 10*y0 + 3*Y2))/40320.;
}
float i2cell20_B0C05(float x, float t, float y0) {
    return
    (9*T4*(-84 + 112*X5 - 200*X7 + 105*X8) + 168*t*(-14 + 60*X2 - 75*X4 + 36*X5)*(1 + y0)*POW2(2 + y0) + 70*(12 + 24*x - 20*X3 + 9*X4)*POW3(2 + y0)*(2 + 3*y0) + 16*T3*(31 + 105*X4 - 175*X6 + 90*X7)*(5 + 3*y0) + 840*T2*X3*(4 - 6*X2 + 3*X3)*(8 + 10*y0 + 3*Y2))/40320.;
}
float i2cell30_B0C05(float x, float t, float y0) {
    return
    (-960*T4 - 315*T4*X8 - 2688*t*(1 + y0)*POW2(2 + y0) - 1120*POW3(2 + y0)*(2 + 3*y0) + 3360*x*POW3(2 + y0)*(2 + 3*y0) + 512*T3*(5 + 3*y0) + 120*T3*X7*(15*t - 4*(5 + 3*y0)) - 1344*T2*(8 + 10*y0 + 3*Y2) - 3360*X2*POW2(2 + y0)*(4 + 8*y0 - 6*t*(1 + y0) + 3*Y2) - 280*T2*X6*(24 + 12*T2 + 30*y0 - 10*t*(5 + 3*y0) + 9*Y2) + 280*X3*(2 + y0)*(5*POW2(2 + y0)*(2 + 3*y0) + 24*T2*(4 + 3*y0) - 96*t*(2 + 3*y0 + Y2)) + 336*t*X5*(6*T3 - 6*(1 + y0)*POW2(2 + y0) - 16*T2*(5 + 3*y0) + 15*t*(8 + 10*y0 + 3*Y2)) + 210*X4*(60*t*(1 + y0)*POW2(2 + y0) - POW3(2 + y0)*(2 + 3*y0) + 16*T3*(5 + 3*y0) - 48*T2*(8 + 10*y0 + 3*Y2)) + 24*(9*T4 + 70*POW3(2 + y0)*(2 + 3*y0) + 56*T2*(8 + 10*y0 + 3*Y2)))/40320.;
}
float i2cell01_B0C05(float x, float t, float y0) {
    return
    -(POW3(2 + x)*(9*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(5 + 9*y0) + 840*T2*X3*y0*(10 + 9*y0) + 168*t*(-2 + 3*x + 12*X2)*(-2 + 5*Y2 + 3*Y3) + 70*(2 + 3*x)*(-12 - 24*y0 + 20*Y3 + 9*Y4)))/40320.;
}
float i2cell11_B0C05(float x, float t, float y0) {
    return
    (27*T4*(84 - 112*X5 + 200*X7 + 105*X8) + 16*T3*(-31 - 105*X4 + 175*X6 + 90*X7)*(5 + 9*y0) + 840*T2*X3*(-4 + 6*X2 + 3*X3)*y0*(10 + 9*y0) + 168*t*(14 - 60*X2 + 75*X4 + 36*X5)*(-2 + 5*Y2 + 3*Y3) + 70*(-12 - 24*x + 20*X3 + 9*X4)*(-12 - 24*y0 + 20*Y3 + 9*Y4))/40320.;
}
float i2cell21_B0C05(float x, float t, float y0) {
    return
    (-27*T4*(-84 + 112*X5 - 200*X7 + 105*X8) - 16*T3*(31 + 105*X4 - 175*X6 + 90*X7)*(5 + 9*y0) - 840*T2*X3*(4 - 6*X2 + 3*X3)*y0*(10 + 9*y0) - 168*t*(-14 + 60*X2 - 75*X4 + 36*X5)*(-2 + 5*Y2 + 3*Y3) - 70*(12 + 24*x - 20*X3 + 9*X4)*(-12 - 24*y0 + 20*Y3 + 9*Y4))/40320.;
}
float i2cell31_B0C05(float x, float t, float y0) {
    return
    (9*T4*(248 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(5 + 9*y0) + 840*T2*POW3(-2 + x)*X3*y0*(10 + 9*y0) + 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*(-2 + 5*Y2 + 3*Y3) + 70*(-8 - 48*x + 48*X2 - 20*X3 + 3*X4)*(-12 - 24*y0 + 20*Y3 + 9*Y4))/40320.;
}
float i2cell02_B0C05(float x, float t, float y0) {
    return
    (POW3(2 + x)*(9*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 840*T2*X3*y0*(-10 + 9*y0) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(-5 + 9*y0) + 168*t*(-2 + 3*x + 12*X2)*(2 - 5*Y2 + 3*Y3) + 70*(2 + 3*x)*(12 + 24*y0 - 20*Y3 + 9*Y4)))/40320.;
}
float i2cell12_B0C05(float x, float t, float y0) {
    return
    (-27*T4*(84 - 112*X5 + 200*X7 + 105*X8) - 840*T2*X3*(-4 + 6*X2 + 3*X3)*y0*(-10 + 9*y0) - 16*T3*(-31 - 105*X4 + 175*X6 + 90*X7)*(-5 + 9*y0) - 168*t*(14 - 60*X2 + 75*X4 + 36*X5)*(2 - 5*Y2 + 3*Y3) - 70*(-12 - 24*x + 20*X3 + 9*X4)*(12 + 24*y0 - 20*Y3 + 9*Y4))/40320.;
}
float i2cell22_B0C05(float x, float t, float y0) {
    return
    (27*T4*(-84 + 112*X5 - 200*X7 + 105*X8) + 840*T2*X3*(4 - 6*X2 + 3*X3)*y0*(-10 + 9*y0) + 16*T3*(31 + 105*X4 - 175*X6 + 90*X7)*(-5 + 9*y0) + 168*t*(-14 + 60*X2 - 75*X4 + 36*X5)*(2 - 5*Y2 + 3*Y3) + 70*(12 + 24*x - 20*X3 + 9*X4)*(12 + 24*y0 - 20*Y3 + 9*Y4))/40320.;
}
float i2cell32_B0C05(float x, float t, float y0) {
    return
    (-9*T4*(248 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) - 840*T2*POW3(-2 + x)*X3*y0*(-10 + 9*y0) - 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(-5 + 9*y0) - 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*(2 - 5*Y2 + 3*Y3) - 70*(-8 - 48*x + 48*X2 - 20*X3 + 3*X4)*(12 + 24*y0 - 20*Y3 + 9*Y4))/40320.;
}
float i2cell03_B0C05(float x, float t, float y0) {
    return
    -(POW3(2 + x)*(-840*(2 + 3*x) + (3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5))/2. + 84*t*(-2 + 3*x + 12*X2)*POW2(-2 + y0)*(-1 + y0) + 8*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(-5 + 3*y0) + 35*(2 + 3*x)*POW3(-2 + y0)*(-2 + 3*y0) + 420*T2*X3*(8 - 10*y0 + 3*Y2)))/20160.;
}
float i2cell13_B0C05(float x, float t, float y0) {
    return
    (9*T4*(84 - 112*X5 + 200*X7 + 105*X8) + 168*t*(14 - 60*X2 + 75*X4 + 36*X5)*POW2(-2 + y0)*(-1 + y0) + 16*T3*(-31 - 105*X4 + 175*X6 + 90*X7)*(-5 + 3*y0) + 840*T2*X3*(-4 + 6*X2 + 3*X3)*(8 - 10*y0 + 3*Y2) + 70*(-12 - 24*x + 20*X3 + 9*X4)*(-8 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4))/40320.;
}
float i2cell23_B0C05(float x, float t, float y0) {
    return
    (-9*T4*(-84 + 112*X5 - 200*X7 + 105*X8) - 168*t*(-14 + 60*X2 - 75*X4 + 36*X5)*POW2(-2 + y0)*(-1 + y0) - 16*T3*(31 + 105*X4 - 175*X6 + 90*X7)*(-5 + 3*y0) - 840*T2*X3*(4 - 6*X2 + 3*X3)*(8 - 10*y0 + 3*Y2) - 70*(12 + 24*x - 20*X3 + 9*X4)*(-8 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4))/40320.;
}
float i2cell33_B0C05(float x, float t, float y0) {
    return
    (40320 + 3*T4*(320 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*POW2(-2 + y0)*(-1 + y0) + 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(-5 + 3*y0) + 70*POW3(-2 + x)*(-2 + 3*x)*POW3(-2 + y0)*(-2 + 3*y0) + 168*T2*(8 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*(8 - 10*y0 + 3*Y2) - 24*(9*T4 + 56*T2*(8 - 10*y0 + 3*Y2) + 70*(32 - 48*x + 48*X2 - 20*X3 + 3*X4 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4)))/40320.;
}

#pragma endregion 

#pragma region horizontal cell borders constant expressions
// generated in cubicMitchell-mm113_4x4cellsAproach.nb

float HygxBorder04_B0C05(float t, float y0) {
    return
    -(POW6(-2 - 2*t + y0)*(12 + 12*T2 + 12*y0 + 4*t*(-8 + 3*y0) - 9*Y2))/(40320.*POW4(t));
}
float HygxBorder14_B0C05(float t, float y0) {
    return
    (-756*T8 - 2352*T5*POW2(-2 + y0)*(-1 + y0) + 496*T7*(-5 + 3*y0) + 840*T4*POW3(-2 + y0)*(-2 + 3*y0) - 336*T3*POW4(-2 + y0)*(-1 + 3*y0) + 40*t*POW6(-2 + y0)*(1 + 3*y0) - 9*POW7(-2 + y0)*(2 + 3*y0))/(40320.*POW4(t));
}
float HygxBorder24_B0C05(float t, float y0) {
    return
    (-756*T8 - 2352*T5*POW2(-2 + y0)*(-1 + y0) + 496*T7*(-5 + 3*y0) + 840*T4*POW3(-2 + y0)*(-2 + 3*y0) - 336*T3*POW4(-2 + y0)*(-1 + 3*y0) + 40*t*POW6(-2 + y0)*(1 + 3*y0) + 9*POW7(-2 + y0)*(2 + 3*y0))/(40320.*POW4(t));
}
float HygxBorder34_B0C05(float t, float y0) {
    return
    -(744*T8 + 2688*T5*POW2(-2 + y0)*(-1 + y0) + 672*T2*POW5(-2 + y0)*y0 - 512*T7*(-5 + 3*y0) - 560*T4*POW3(-2 + y0)*(-2 + 3*y0) + 672*T3*POW4(-2 + y0)*(-1 + 3*y0) + 40*t*POW6(-2 + y0)*(1 + 3*y0) + 3*POW7(-2 + y0)*(2 + 3*y0))/(40320.*POW4(t));
}
float HygxBorder03_B0C05(float t, float y0) {
    return
    (POW6(-1 - 2*t + y0)*(3 + 12*T2 + 6*y0 + 4*t*(-4 + 3*y0) - 9*Y2))/(10080.*POW4(t));
}
float HygxBorder13_B0C05(float t, float y0) {
    return
    (756*T8 + 1176*T5*POW2(-1 + y0)*(-1 + 2*y0) - 840*T4*POW3(-1 + y0)*(-1 + 3*y0) + 9*POW7(-1 + y0)*(1 + 3*y0) - 248*T7*(-5 + 6*y0) + 168*T3*POW4(-1 + y0)*(-1 + 6*y0) - 20*t*POW6(-1 + y0)*(1 + 6*y0))/(10080.*POW4(t));
}
float HygxBorder23_B0C05(float t, float y0) {
    return
    (756*T8 + 1176*T5*POW2(-1 + y0)*(-1 + 2*y0) - 840*T4*POW3(-1 + y0)*(-1 + 3*y0) - 9*POW7(-1 + y0)*(1 + 3*y0) - 248*T7*(-5 + 6*y0) + 168*T3*POW4(-1 + y0)*(-1 + 6*y0) - 20*t*POW6(-1 + y0)*(1 + 6*y0))/(10080.*POW4(t));
}
float HygxBorder33_B0C05(float t, float y0) {
    return
    (744*T8 + 672*T2*POW5(-1 + y0)*y0 + 1344*T5*POW2(-1 + y0)*(-1 + 2*y0) - 560*T4*POW3(-1 + y0)*(-1 + 3*y0) + 3*POW7(-1 + y0)*(1 + 3*y0) - 256*T7*(-5 + 6*y0) + 336*T3*POW4(-1 + y0)*(-1 + 6*y0) + 20*t*POW6(-1 + y0)*(1 + 6*y0))/(10080.*POW4(t));
}
float HygxBorder02_B0C05(float t, float y0) {
    return
    -(POW7(2*t - y0)*(2*t + 3*y0))/(2240.*POW4(t));
}
float HygxBorder12_B0C05(float t, float y0) {
    return
    -(252*T8 - 496*T7*y0 + 784*T5*Y3 - 840*T4*Y4 + 336*T3*Y5 - 40*t*Y7 + 9*Y8)/(2240.*POW4(t));
}
float HygxBorder22_B0C05(float t, float y0) {
    return
    (-252*T8 + 496*T7*y0 - 784*T5*Y3 + 840*T4*Y4 - 336*T3*Y5 + 40*t*Y7 + 9*Y8)/(2240.*POW4(t));
}
float HygxBorder32_B0C05(float t, float y0) {
    return
    -(248*T8 - 512*T7*y0 + 896*T5*Y3 - 560*T4*Y4 + 672*T3*Y5 + 224*T2*Y6 + 40*t*Y7 + 3*Y8)/(2240.*POW4(t));
}
float HygxBorder01_B0C05(float t, float y0) {
    return
    (POW6(1 - 2*t + y0)*(3 + 12*T2 - 6*y0 + 4*t*(4 + 3*y0) - 9*Y2))/(10080.*POW4(t));
}
float HygxBorder11_B0C05(float t, float y0) {
    return
    (756*T8 + 1176*T5*POW2(1 + y0)*(1 + 2*y0) + 9*POW7(1 + y0)*(-1 + 3*y0) - 840*T4*POW3(1 + y0)*(1 + 3*y0) - 20*t*POW6(1 + y0)*(-1 + 6*y0) + 168*T3*POW4(1 + y0)*(1 + 6*y0) - 248*T7*(5 + 6*y0))/(10080.*POW4(t));
}
float HygxBorder21_B0C05(float t, float y0) {
    return
    (756*T8 + 1176*T5*POW2(1 + y0)*(1 + 2*y0) - 9*POW7(1 + y0)*(-1 + 3*y0) - 840*T4*POW3(1 + y0)*(1 + 3*y0) - 20*t*POW6(1 + y0)*(-1 + 6*y0) + 168*T3*POW4(1 + y0)*(1 + 6*y0) - 248*T7*(5 + 6*y0))/(10080.*POW4(t));
}
float HygxBorder31_B0C05(float t, float y0) {
    return
    (744*T8 + 672*T2*y0*POW5(1 + y0) + 1344*T5*POW2(1 + y0)*(1 + 2*y0) + 3*POW7(1 + y0)*(-1 + 3*y0) - 560*T4*POW3(1 + y0)*(1 + 3*y0) + 20*t*POW6(1 + y0)*(-1 + 6*y0) + 336*T3*POW4(1 + y0)*(1 + 6*y0) - 256*T7*(5 + 6*y0))/(10080.*POW4(t));
}
float HygxBorder00_B0C05(float t, float y0) {
    return
    -(POW6(2 - 2*t + y0)*(12*T2 + 4*t*(8 + 3*y0) - 3*(-4 + 4*y0 + 3*Y2)))/(40320.*POW4(t));
}
float HygxBorder10_B0C05(float t, float y0) {
    return
    -(432*T8 - 336*T5*(1 + y0)*POW2(2 + y0) - (3*POW7(2 + y0)*(-2 + 3*y0))/2. + 4*t*POW6(2 + y0)*(-1 + 3*y0) - 368*T7*(5 + 3*y0) - 6*POW6(2 - t + y0)*(4 + 9*T2 + t*(8 - 6*y0) - 4*y0 - 3*Y2) + 336*T6*(8 + 10*y0 + 3*Y2))/(20160.*POW4(t));
}
float HygxBorder20_B0C05(float t, float y0) {
    return
    (-756*T8 - 2352*T5*(1 + y0)*POW2(2 + y0) + 9*POW7(2 + y0)*(-2 + 3*y0) + 40*t*POW6(2 + y0)*(-1 + 3*y0) - 336*T3*POW4(2 + y0)*(1 + 3*y0) + 840*T4*POW3(2 + y0)*(2 + 3*y0) + 496*T7*(5 + 3*y0))/(40320.*POW4(t));
}
float HygxBorder30_B0C05(float t, float y0) {
    return
    (-744*T4 - 2688*t*(1 + y0)*POW2(2 + y0) - (672*y0*POW5(2 + y0))/POW2(t) + (40*(1 - 3*y0)*POW6(2 + y0))/POW3(t) + (3*(2 - 3*y0)*POW7(2 + y0))/POW4(t) - (672*POW4(2 + y0)*(1 + 3*y0))/t + 560*POW3(2 + y0)*(2 + 3*y0) + 512*T3*(5 + 3*y0))/40320.;
}


#pragma endregion 

#pragma region Hygx_cubic
float Hygx_cubic_B0C05(float xIn, float t, float y0)
{
    float x = min(xIn, 1.9999);   // clip x against right border of filter footprint
                                // such that value at x==2 is being repeated for all x>2
                                // TODO: change 1.9999 into 2.0
    float gx = t * x + y0;  // y=g(x) defines the (diagonal) line where integration is along

    if (x <= -2.0 + 0.0001) return 0; // to the west of all cells, obtaining weight = 0
    // Next "early exit" can safely be omitted.
    if (t >= 0 && gx < -2) return 0; // to the south of all cells, only with positive tangent, obtains weight = 0

    // first, evaluate base integral Hygx-cells for the 16 cell area's
    // ---------------------------------------------------------------
    float wBase = 0; // weight of cell integral (with constants for vertical line x == -2,-1,0,1,2)

    // globals; made powers of x and t globals to reduce code redundancy for now.
    // Compute these powers here i.s.o. in each of the cell functions
    X2 = x*x; X3 = X2*x; X4 = X3*x; X5 = X4*x; X6 = X5*x; X7 = X6*x; X8 = X7*x;
    T2 = t*t; T3 = T2*t; T4 = T3*t; T5 = T4*t; T6 = T5*t; T7 = T6*t; T8 = T7*t;
    Y2 = y0*y0; Y3 = Y2*y0; Y4 = Y3*y0; Y5 = Y4*y0; Y6 = Y5*y0; Y7 = Y6*y0; Y8 = Y7*y0;

    // NOTE: ONLY THE BASE FUNCTIONS WITHIN THE AA-FILTER FOOTPRINT NEED TO BE IMPLEMENTED
    // VERTICAL CLIPPING IN WtEdgeAB ensures functions outside are not required.
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (gx >= +1) { wBase = i2cell03_B0C05(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell02_B0C05(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell01_B0C05(x, t, y0); }
        else               { wBase = i2cell00_B0C05(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (gx >= +1) { wBase = i2cell13_B0C05(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell12_B0C05(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell11_B0C05(x, t, y0); }
        else               { wBase = i2cell10_B0C05(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (gx >= +1) { wBase = i2cell23_B0C05(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell22_B0C05(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell21_B0C05(x, t, y0); }
        else               { wBase = i2cell20_B0C05(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (gx >= +1) { wBase = i2cell33_B0C05(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell32_B0C05(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell31_B0C05(x, t, y0); }
        else               { wBase = i2cell30_B0C05(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }

    // second, add diagonal "row"-constants ALLONG TANGENT LINE for (overlapping) area's
    // ---------------------------------------------------------------------------------

    // Compute integral constants at horizontal cell piecewise discontinuities at HygxBorder[xy]
    // Where [xy] indicate the bottom border of cell[xy].
    // 2D overlapping area's of constants are defined by 
    // - horizontal range   where x is restricted to -2 < x < +2
    // - vertical range     where gx is restricted
    // - diagonal range     where y0 is restricted

    float wConst = 0;
    int st = SIGN(t);

    // HygxBorder*4: Only needed for negative tangent; below horizontal line: g(x) = +2
    if (t < 0 && gx <= 2.0001)
    {
        // Border04 for negative t:  y0 <= 2 + t  &&  y0 > 2 + 2t (since st=-1, conditions can be simplified)
        if      ( ((2 +   t - y0)*st <= 0)  &&  ((2 + 2*t - y0)*st > 0) ) wConst += HygxBorder04_B0C05(t, y0);
        else if ( ((2       - y0)*st <= 0)  &&  ((2 +   t - y0)*st > 0) ) wConst += HygxBorder14_B0C05(t, y0);
        else if ( ((2 -   t - y0)*st <= 0)  &&  ((2       - y0)*st > 0) ) wConst += HygxBorder24_B0C05(t, y0);
        else if (/*(2 - 2*t - y0)*st <= 0 */    ((2 -   t - y0)*st > 0) ) wConst += HygxBorder34_B0C05(t, y0);
    }
    // HygxBorder*3: For positive and negative tangent; above respectively below horizontal line: g(x) = +1
    if ( (t >= 0 && gx >= 1) || (t < 0 && gx < 1) )
    {
        // Border03 positive t: y0 >= 1 + t  &&  y0 < 1 + 2t, negative t: y0 <= 1 + t  &&  y0 > 1 + 2t
        if      ( ((1 +   t - y0)*st <= 0)  &&  ((1 + 2*t - y0)*st > 0) ) wConst += HygxBorder03_B0C05(t, y0);
        else if ( ((1       - y0)*st <= 0)  &&  ((1 +   t - y0)*st > 0) ) wConst += HygxBorder13_B0C05(t, y0);
        else if ( ((1 -   t - y0)*st <= 0)  &&  ((1       - y0)*st > 0) ) wConst += HygxBorder23_B0C05(t, y0);
        else if (/*(1 - 2*t - y0)*st <= 0 */    ((1 -   t - y0)*st > 0) ) wConst += HygxBorder33_B0C05(t, y0);
    }
    // HygxBorder*2: For positive and negative tangent; above respectively below horizontal line: g(x) = 0
    if ( (t >= 0 && gx >= 0) || (t < 0 && gx < 0) )
    {
        // Border02 positive t: y0 >= 0 + t  &&  y0 < 0 + 2t, negative t: y0 <= 0 + t  &&  y0 > 0 + 2t
        if      ( ((0 +   t - y0)*st <= 0)  &&  ((0 + 2*t - y0)*st > 0) ) wConst += HygxBorder02_B0C05(t, y0);
        else if ( ((0       - y0)*st <= 0)  &&  ((0 +   t - y0)*st > 0) ) wConst += HygxBorder12_B0C05(t, y0);
        else if ( ((0 -   t - y0)*st <= 0)  &&  ((0       - y0)*st > 0) ) wConst += HygxBorder22_B0C05(t, y0);
        else if (/*(0 - 2*t - y0)*st <= 0 */    ((0 -   t - y0)*st > 0) ) wConst += HygxBorder32_B0C05(t, y0);
    }
    // HygxBorder*1: For positive and negative tangent; above respectively below horizontal line: g(x) = -1
    if ( (t >= 0 && gx >= -1) || (t < 0 && gx < -1) )
    {
        // Border01 positive t: y0 >= -1 + t  &&  y0 < -1 + 2t, negative t: y0 <= -1 + t  &&  y0 > -1 + 2t
        if      ( ((-1 +   t - y0)*st <= 0)  &&  ((-1 + 2*t - y0)*st > 0) ) wConst += HygxBorder01_B0C05(t, y0);
        else if ( ((-1       - y0)*st <= 0)  &&  ((-1 +   t - y0)*st > 0) ) wConst += HygxBorder11_B0C05(t, y0);
        else if ( ((-1 -   t - y0)*st <= 0)  &&  ((-1       - y0)*st > 0) ) wConst += HygxBorder21_B0C05(t, y0);
        else if (/*(-1 - 2*t - y0)*st <= 0 */    ((-1 -   t - y0)*st > 0) ) wConst += HygxBorder31_B0C05(t, y0);
    }
    // HygxBorder*0: Only needed for positive tangent; above horizontal line: g(x) = -2
    if ( t > 0 && gx >= -2 )
    {
        // Border00 positive t: y0 >= -2 + t  &&  y0 < -2 + 2t (since st=1, conditions can be simplified)
        if      ( ((-2 +   t - y0)*st <= 0)  &&  ((-2 + 2*t - y0)*st > 0) ) wConst += HygxBorder00_B0C05(t, y0);
        else if ( ((-2       - y0)*st <= 0)  &&  ((-2 +   t - y0)*st > 0) ) wConst += HygxBorder10_B0C05(t, y0);
        else if ( ((-2 -   t - y0)*st <= 0)  &&  ((-2       - y0)*st > 0) ) wConst += HygxBorder20_B0C05(t, y0);
        else if (/*(-2 - 2*t - y0)*st <= 0 */    ((-2 -   t - y0)*st > 0) ) wConst += HygxBorder30_B0C05(t, y0);
    }

    float weight = wBase - wConst * st;
    return weight;
}
#pragma endregion

// ============================================================================

#pragma region Hyx polynomials
// When tangent=0, i.e. exact horizontal edge. Robust against xa==xb

float HyxCell00_B0C05(float x, float y) {
    return
    (POW3(2 + x)*(2 + 3*x)*POW3(2 + y)*(2 + 3*y))/576.;
}
float HyxCell10_B0C05(float x, float y) {
    return
    ((12 + 24*x - 20*X3 - 9*X4)*POW3(2 + y)*(2 + 3*y))/576.;
}
float HyxCell20_B0C05(float x, float y) {
    return
    ((12 + 24*x - 20*X3 + 9*X4)*POW3(2 + y)*(2 + 3*y))/576.;
}
float HyxCell30_B0C05(float x, float y) {
    return
    -((-24 + POW3(-2 + x)*(-2 + 3*x))*POW3(2 + y)*(2 + 3*y))/576.;
}
float HyxCell01_B0C05(float x, float y) {
    return
    (POW3(2 + x)*(2 + 3*x)*(12 + 24*y - 20*Y3 - 9*Y4))/576.;
}
float HyxCell11_B0C05(float x, float y) {
    return
    ((-12 - 24*x + 20*X3 + 9*X4)*(-12 - 24*y + 20*Y3 + 9*Y4))/576.;
}
float HyxCell21_B0C05(float x, float y) {
    return
    -((12 + 24*x - 20*X3 + 9*X4)*(-12 - 24*y + 20*Y3 + 9*Y4))/576.;
}
float HyxCell31_B0C05(float x, float y) {
    return
    ((-8 - 48*x + 48*X2 - 20*X3 + 3*X4)*(-12 - 24*y + 20*Y3 + 9*Y4))/576.;
}
float HyxCell02_B0C05(float x, float y) {
    return
    (POW3(2 + x)*(2 + 3*x)*(12 + 24*y - 20*Y3 + 9*Y4))/576.;
}
float HyxCell12_B0C05(float x, float y) {
    return
    -((-12 - 24*x + 20*X3 + 9*X4)*(12 + 24*y - 20*Y3 + 9*Y4))/576.;
}
float HyxCell22_B0C05(float x, float y) {
    return
    ((12 + 24*x - 20*X3 + 9*X4)*(12 + 24*y - 20*Y3 + 9*Y4))/576.;
}
float HyxCell32_B0C05(float x, float y) {
    return
    -((-8 - 48*x + 48*X2 - 20*X3 + 3*X4)*(12 + 24*y - 20*Y3 + 9*Y4))/576.;
}
float HyxCell03_B0C05(float x, float y) {
    return
    -(POW3(2 + x)*(2 + 3*x)*(-24 + POW3(-2 + y)*(-2 + 3*y)))/576.;
}
float HyxCell13_B0C05(float x, float y) {
    return
    ((-12 - 24*x + 20*X3 + 9*X4)*(-8 - 48*y + 48*Y2 - 20*Y3 + 3*Y4))/576.;
}
float HyxCell23_B0C05(float x, float y) {
    return
    -((12 + 24*x - 20*X3 + 9*X4)*(-8 - 48*y + 48*Y2 - 20*Y3 + 3*Y4))/576.;
}
float HyxCell33_B0C05(float x, float y) {
    return
    ((-8 - 48*x + 48*X2 - 20*X3 + 3*X4)*(-8 - 48*y + 48*Y2 - 20*Y3 + 3*Y4))/576.;
}

float Hyx_cubicB0C05(float x, float y)
{
	// globals; gives more readable cell functions and reduces redundancy
	X2 = x*x; X3 = X2*x; X4 = X3*x;
    Y2 = y*y; Y3 = Y2*y; Y4 = Y3*y;
    float w = 0;
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (y >= +1) w = HyxCell03_B0C05(x, y);
        else if (y >=  0) w = HyxCell02_B0C05(x, y);
        else if (y >= -1) w = HyxCell01_B0C05(x, y);
        else              w = HyxCell00_B0C05(x, y);
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (y >= +1) w = HyxCell13_B0C05(x, y);
        else if (y >=  0) w = HyxCell12_B0C05(x, y);
        else if (y >= -1) w = HyxCell11_B0C05(x, y);
        else              w = HyxCell10_B0C05(x, y);
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (y >= +1) w = HyxCell23_B0C05(x, y);
        else if (y >=  0) w = HyxCell22_B0C05(x, y);
        else if (y >= -1) w = HyxCell21_B0C05(x, y);
        else              w = HyxCell20_B0C05(x, y);
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (y >= +1) w = HyxCell33_B0C05(x, y);
        else if (y >=  0) w = HyxCell32_B0C05(x, y);
        else if (y >= -1) w = HyxCell31_B0C05(x, y);
        else              w = HyxCell30_B0C05(x, y);
    }
    return w;
}
#pragma endregion
