// Inverse analytical texture mapping (ATM)

#version 430

#define dFloat float  // used for Hygx_cubicBC filter functions (not needed for Hyx_cubicBC's filter functions)
// Before 2024-06-30 (rev. ab93c) single-precision float gives "speclels" (overflow) on multiple places; double is fine.
// 		Running in double-precision is less supported (erroneous exit during run on Acer Aspire 571G)
// After that revision all POW5(t) and POW5(y0) are premultiplied into T5 and T5, same for higher terms;
// apparently that has solved the speckle overflow issue (so no need any more to have dFloat set to double).

#define SIGN(x)           ( int(x >= 0) - int(x < 0) )  // GLSL sign(0) gives 0 i.s.o 1

// #defines and globals
#define POW2(x)	((x)*(x))
#define POW3(x)	((x)*(x)*(x))
#define POW4(x)	((x)*(x)*(x)*(x))
#define POW5(x)	((x)*(x)*(x)*(x)*(x))
#define POW6(x)	((x)*(x)*(x)*(x)*(x)*(x))
#define POW7(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x))
#define POW8(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x)*(x))

float X2, X3, X4, X5, X6, X7, X8;
float T2, T3, T4, T5, T6, T7, T8;
float Y2, Y3, Y4, Y5, Y6, Y7, Y8;

// #define B 0.5 // 5 fps
// #define C 0.5
uniform float B; // 4 fps
uniform float C;

#pragma region Cubic BC Base integral Cell expressions

// generated with cubicMitchellBC-generic-mm113.nb

float i2cell00_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (-32*POW2(B + 6*C)*T4 + (POW2(B + 6*C)*T4*X8)/8. + 16*(B + 3*C)*POW3(2 + y0)*(B*(2 + y0) + 2*C*(2 + 3*y0)) + 8*(B + 3*C)*x*POW3(2 + y0)*(B*(2 + y0) + 2*C*(2 + 3*y0)) + (256*(B + 6*C)*T3*(B*(4 + 3*t + 2*y0) + C*(20 + 15*t + 12*y0)))/7. + (2*(B + 6*C)*T3*X7*(B*(4 + 3*t + 2*y0) + C*(20 + 15*t + 12*y0)))/7. - 8*POW2(2 + y0)*(POW2(B)*(2 + y0)*(6 + 8*t + 3*y0) + 24*POW2(C)*(4 + 8*y0 + 6*t*(1 + y0) + 3*Y2) + 6*B*C*(12 + 16*y0 + 4*t*(4 + 3*y0) + 5*Y2)) + 2*X2*POW2(2 + y0)*(POW2(B)*(2 + y0)*(6 + 8*t + 3*y0) + 24*POW2(C)*(4 + 8*y0 + 6*t*(1 + y0) + 3*Y2) + 6*B*C*(12 + 16*y0 + 4*t*(4 + 3*y0) + 5*Y2)) - 64*T2*(POW2(B)*(2*T2 + 4*t*(2 + y0) + POW2(2 + y0)) + 4*B*C*(10 + 5*T2 + 11*y0 + t*(20 + 11*y0) + 3*Y2) + 4*POW2(C)*(24 + 12*T2 + 30*y0 + 10*t*(5 + 3*y0) + 9*Y2)) + T2*X6*(POW2(B)*(2*T2 + 4*t*(2 + y0) + POW2(2 + y0)) + 4*B*C*(10 + 5*T2 + 11*y0 + t*(20 + 11*y0) + 3*Y2) + 4*POW2(C)*(24 + 12*T2 + 30*y0 + 10*t*(5 + 3*y0) + 9*Y2)) + 16*(2 + y0)*(POW2(B)*(2 + y0)*(8*T2 + 8*t*(2 + y0) + POW2(2 + y0)) + 2*POW2(C)*(5*POW2(2 + y0)*(2 + 3*y0) + 24*T2*(4 + 3*y0) + 96*t*(2 + 3*y0 + Y2)) + B*C*(8*T2*(14 + 9*y0) + POW2(2 + y0)*(14 + 11*y0) + 16*t*(14 + 17*y0 + 5*Y2))) + 2*X3*(2 + y0)*(POW2(B)*(2 + y0)*(8*T2 + 8*t*(2 + y0) + POW2(2 + y0)) + 2*POW2(C)*(5*POW2(2 + y0)*(2 + 3*y0) + 24*T2*(4 + 3*y0) + 96*t*(2 + 3*y0 + Y2)) + B*C*(8*T2*(14 + 9*y0) + POW2(2 + y0)*(14 + 11*y0) + 16*t*(14 + 17*y0 + 5*Y2))) - 4*(POW2(B)*(2 + y0)*(32*T3 + 72*T2*(2 + y0) + 24*t*POW2(2 + y0) + POW3(2 + y0)) + 12*POW2(C)*(60*t*(1 + y0)*POW2(2 + y0) + POW3(2 + y0)*(2 + 3*y0) + 16*T3*(5 + 3*y0) + 48*T2*(8 + 10*y0 + 3*Y2)) + 4*B*C*(POW3(2 + y0)*(4 + 3*y0) + 8*T3*(16 + 9*y0) + 6*t*POW2(2 + y0)*(16 + 11*y0) + 36*T2*(16 + 18*y0 + 5*Y2))) + (X4*(POW2(B)*(2 + y0)*(32*T3 + 72*T2*(2 + y0) + 24*t*POW2(2 + y0) + POW3(2 + y0)) + 12*POW2(C)*(60*t*(1 + y0)*POW2(2 + y0) + POW3(2 + y0)*(2 + 3*y0) + 16*T3*(5 + 3*y0) + 48*T2*(8 + 10*y0 + 3*Y2)) + 4*B*C*(POW3(2 + y0)*(4 + 3*y0) + 8*T3*(16 + 9*y0) + 6*t*POW2(2 + y0)*(16 + 11*y0) + 36*T2*(16 + 18*y0 + 5*Y2))))/4. + (128*t*(POW2(B)*(2*T3 + 12*T2*(2 + y0) + 9*t*POW2(2 + y0) + POW3(2 + y0)) + 6*POW2(C)*(6*T3 + 6*(1 + y0)*POW2(2 + y0) + 16*T2*(5 + 3*y0) + 15*t*(8 + 10*y0 + 3*Y2)) + 3*B*C*(6*T3 + 2*POW2(2 + y0)*(3 + 2*y0) + 8*T2*(9 + 5*y0) + 3*t*(36 + 40*y0 + 11*Y2))))/5. + (4*t*X5*(POW2(B)*(2*T3 + 12*T2*(2 + y0) + 9*t*POW2(2 + y0) + POW3(2 + y0)) + 6*POW2(C)*(6*T3 + 6*(1 + y0)*POW2(2 + y0) + 16*T2*(5 + 3*y0) + 15*t*(8 + 10*y0 + 3*Y2)) + 3*B*C*(6*T3 + 2*POW2(2 + y0)*(3 + 2*y0) + 8*T2*(9 + 5*y0) + 3*t*(36 + 40*y0 + 11*Y2))))/5.)/144. );
}
float i2cell10_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (216*POW2(B)*T4 + 372*B*C*T4 - 3636*POW2(C)*T4 + 4*B*(9 + 87*C)*T4 + 105*(3*POW2(B) + 12*(-2 + C)*C + 4*B*(-1 + 5*C))*T4*X8 - 752*POW2(B)*T3*(2 + y0) + 1008*POW2(B)*T2*POW2(2 + y0) + 4704*POW2(C)*t*(1 + y0)*POW2(2 + y0) - 560*POW2(B)*t*POW3(2 + y0) + 280*B*C*y0*POW3(2 + y0) - 280*POW2(C)*POW3(2 + y0)*(2 + 3*y0) + 3264*POW2(C)*T3*(5 + 3*y0) - 112*B*C*t*POW2(2 + y0)*(4 + 11*y0) - 32*B*C*T3*(58 + 45*y0) - 280*B*POW3(2 + y0)*(-6 + (-3 + C)*y0) - 336*B*t*POW2(2 + y0)*(6 + 6*C + 3*y0 + 5*C*y0) + 224*B*T2*(2 + y0)*(6 + 17*C + 3*y0 + 12*C*y0) - 80*B*T3*(6 + 34*C + 3*y0 + 20*C*y0) - 1120*(-3 + B)*t*X2*POW2(2 + y0)*(6*C*(1 + y0) + B*(2 + y0)) - 560*(-3 + B)*x*POW3(2 + y0)*(B*(2 + y0) + 2*C*(2 + 3*y0)) + 240*T3*X7*(2*POW2(B)*(6 + t + 3*y0) + 2*C*(-9*t - 8*(5 + 3*y0) + C*(20 + 3*t + 12*y0)) + B*(-3*t - 8*(2 + y0) + C*(68 + 13*t + 40*y0))) + 560*X3*(2 + y0)*(2*POW2(B)*(2 + y0)*(-T2 + POW2(2 + y0)) + 2*C*(-3*POW2(2 + y0)*(2 + 3*y0) + C*POW2(2 + y0)*(2 + 3*y0) + 6*T2*(4 + 3*y0)) + B*(-3*(2 + y0)*(-2*T2 + POW2(2 + y0)) + C*(-4*T2*(4 + 3*y0) + POW2(2 + y0)*(10 + 13*y0)))) - 3360*POW2(C)*T2*(8 + 10*y0 + 3*Y2) + 224*B*C*T2*(14 + 25*y0 + 9*Y2) + 24*C*(9*T4 - 252*t*(1 + y0)*POW2(2 + y0) + 70*POW3(2 + y0)*(2 + 3*y0) - 20*T3*(5 + 3*y0) + 56*T2*(8 + 10*y0 + 3*Y2)) + 4*POW2(C)*(45*T4 - 504*t*(1 + y0)*POW2(2 + y0) + 70*POW3(2 + y0)*(2 + 3*y0) - 80*T3*(5 + 3*y0) + 168*T2*(8 + 10*y0 + 3*Y2)) - 70*X4*(-(POW2(B)*(2 + y0)*(-8*T3 + 48*t*POW2(2 + y0) + 9*POW3(2 + y0))) + 4*B*(3*(2 + y0)*(-2*T3 + 6*t*POW2(2 + y0) + POW3(2 + y0)) + C*(4*T3*(5 + 3*y0) - 3*POW3(2 + y0)*(4 + 5*y0) - 6*t*POW2(2 + y0)*(14 + 13*y0))) - 12*C*(-36*t*(1 + y0)*POW2(2 + y0) - 2*POW3(2 + y0)*(2 + 3*y0) + 4*T3*(5 + 3*y0) + C*POW2(2 + y0)*(4 + 8*y0 + 12*t*(1 + y0) + 3*Y2))) + 280*T2*X6*(POW2(B)*(2 + y0)*(8*t + 9*(2 + y0)) + 4*C*(-6*(8 + 5*t + 10*y0 + 3*t*y0 + 3*Y2) + C*(24 + 10*t + 30*y0 + 6*t*y0 + 9*Y2)) + 4*B*(-3*(2 + y0)*(2 + t + y0) + C*(42 + 22*t + 51*y0 + 13*t*y0 + 15*Y2))) - 112*t*X5*(POW2(B)*(T3 - 36*t*POW2(2 + y0) - 18*POW3(2 + y0)) - 18*C*(T3 - 8*(1 + y0)*POW2(2 + y0) + 2*C*(2 + y0)*(4 + 4*t + 6*y0 + 3*t*y0 + 2*Y2) - 6*t*(8 + 10*y0 + 3*Y2)) + 3*B*(-T3 + 18*t*POW2(2 + y0) + 8*POW3(2 + y0) + 2*C*(T3 - 2*POW2(2 + y0)*(11 + 10*y0) - 3*t*(36 + 44*y0 + 13*Y2)))))/40320. );
}
float i2cell20_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (2*POW2(B)*t*(27*T3 - 94*T2*(2 + y0) + 126*t*POW2(2 + y0) - 70*POW3(2 + y0)) + B*(9*(1 + 20*C)*T4 + 210*POW4(2 + y0) + 168*T2*(2 + y0)*(2 + y0 + C*(8 + 7*y0)) - 28*t*POW2(2 + y0)*(9*(2 + y0) + C*(22 + 26*y0)) - 4*T3*(15*(2 + y0) + 2*C*(143 + 95*y0))) + 2*C*((27 - 432*C)*T4 + 84*(-9 + 4*C)*t*(1 + y0)*POW2(2 + y0) + 210*POW3(2 + y0)*(2 + 3*y0) + 4*(-15 + 92*C)*T3*(5 + 3*y0) - 168*(-1 + 2*C)*T2*(8 + 10*y0 + 3*Y2)) + 70*((-3*(3*POW2(B) + 12*(-2 + C)*C + 4*B*(-1 + 5*C))*T4*X8)/8. - 4*(-3 + B)*t*X2*POW2(2 + y0)*(6*C*(1 + y0) + B*(2 + y0)) - 2*(-3 + B)*x*POW3(2 + y0)*(B*(2 + y0) + 2*C*(2 + 3*y0)) + (6*T3*X7*(2*POW2(B)*(t - 3*(2 + y0)) + B*(-3*t + C*(-68 + 13*t - 40*y0) + 8*(2 + y0)) + 2*C*(40 - 9*t + 3*C*t + 24*y0 - 4*C*(5 + 3*y0))))/7. + 2*X3*(2 + y0)*(2*POW2(B)*(2 + y0)*(-T2 + POW2(2 + y0)) + 2*C*(-3*POW2(2 + y0)*(2 + 3*y0) + C*POW2(2 + y0)*(2 + 3*y0) + 6*T2*(4 + 3*y0)) + B*(-3*(2 + y0)*(-2*T2 + POW2(2 + y0)) + C*(-4*T2*(4 + 3*y0) + POW2(2 + y0)*(10 + 13*y0)))) - (X4*(POW2(B)*(2 + y0)*(8*T3 - 48*t*POW2(2 + y0) + 9*POW3(2 + y0)) + 4*B*(-3*(2 + y0)*(2*T3 - 6*t*POW2(2 + y0) + POW3(2 + y0)) + C*(4*T3*(5 + 3*y0) + 3*POW3(2 + y0)*(4 + 5*y0) - 6*t*POW2(2 + y0)*(14 + 13*y0))) - 12*C*(-36*t*(1 + y0)*POW2(2 + y0) + 2*POW3(2 + y0)*(2 + 3*y0) + 4*T3*(5 + 3*y0) + C*POW2(2 + y0)*(-4 - 8*y0 + 12*t*(1 + y0) - 3*Y2))))/4. - T2*X6*(POW2(B)*(2 + y0)*(-8*t + 9*(2 + y0)) - 4*C*(48 + 60*y0 - 6*t*(5 + 3*y0) + 2*C*t*(5 + 3*y0) + 18*Y2 - 3*C*(8 + 10*y0 + 3*Y2)) - 4*B*(-3*(-2 + t - y0)*(2 + y0) + C*t*(22 + 13*y0) - 3*C*(14 + 17*y0 + 5*Y2))) - (2*t*X5*(POW2(B)*(T3 - 36*t*POW2(2 + y0) + 18*POW3(2 + y0)) - 18*C*(T3 + 8*(1 + y0)*POW2(2 + y0) - 6*t*(8 + 10*y0 + 3*Y2) + 2*C*(2 + y0)*(t*(4 + 3*y0) - 2*(2 + 3*y0 + Y2))) + 3*B*(-T3 + 18*t*POW2(2 + y0) - 8*POW3(2 + y0) + 2*C*(T3 + 2*POW2(2 + y0)*(11 + 10*y0) - 3*t*(36 + 44*y0 + 13*Y2)))))/5.))/10080. );
}
float i2cell30_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (176*POW2(B)*T4 - 652*B*C*T4 - 564*POW2(C)*T4 - 35*POW2(B + 6*C)*T4*X8 - 1024*POW2(B)*T3*(2 + y0) + 224*POW2(B)*T2*POW2(2 + y0) - 15456*POW2(C)*t*(1 + y0)*POW2(2 + y0) - 1792*POW2(B)*t*POW3(2 + y0) - 1120*POW2(B)*POW4(2 + y0) - 4760*POW2(C)*POW3(2 + y0)*(2 + 3*y0) - 1216*POW2(C)*T3*(5 + 3*y0) - 280*B*C*POW3(2 + y0)*(32 + 31*y0) - 112*B*C*t*POW2(2 + y0)*(124 + 101*y0) - 32*B*C*T3*(198 + 115*y0) + 24*B*(3*T4 + 56*T2*POW2(2 + y0) + 70*POW4(2 + y0)) + 2240*(B + 3*C)*x*POW3(2 + y0)*(B*(2 + y0) + 2*C*(2 + 3*y0)) + 80*(B + 6*C)*T3*X7*(3*B*t + 15*C*t - 2*B*(2 + y0) - 4*C*(5 + 3*y0)) - 3360*POW2(C)*T2*(8 + 10*y0 + 3*Y2) - 672*B*C*T2*(38 + 45*y0 + 13*Y2) + 48*C*(9*T4 + 70*POW3(2 + y0)*(2 + 3*y0) + 56*T2*(8 + 10*y0 + 3*Y2)) - 4*POW2(C)*(819*T4 - 1176*t*(1 + y0)*POW2(2 + y0) - 70*POW3(2 + y0)*(2 + 3*y0) - 816*T3*(5 + 3*y0) + 504*T2*(8 + 10*y0 + 3*Y2)) - 560*X2*POW2(2 + y0)*(POW2(B)*(2 + y0)*(6 - 8*t + 3*y0) + 24*POW2(C)*(4 + 8*y0 - 6*t*(1 + y0) + 3*Y2) + 6*B*C*(12 + 16*y0 - 4*t*(4 + 3*y0) + 5*Y2)) - 280*T2*X6*(POW2(B)*(2*T2 - 4*t*(2 + y0) + POW2(2 + y0)) + 4*B*C*(10 + 5*T2 + 11*y0 - t*(20 + 11*y0) + 3*Y2) + 4*POW2(C)*(24 + 12*T2 + 30*y0 - 10*t*(5 + 3*y0) + 9*Y2)) + 4*B*C*(267*T4 - 70*y0*POW3(2 + y0) - 28*t*POW2(2 + y0)*(4 + 11*y0) - 8*T3*(58 + 45*y0) + 56*T2*(82 + 107*y0 + 33*Y2)) + 560*X3*(2 + y0)*(POW2(B)*(2 + y0)*(8*T2 - 8*t*(2 + y0) + POW2(2 + y0)) + 2*POW2(C)*(5*POW2(2 + y0)*(2 + 3*y0) + 24*T2*(4 + 3*y0) - 96*t*(2 + 3*y0 + Y2)) + B*C*(8*T2*(14 + 9*y0) + POW2(2 + y0)*(14 + 11*y0) - 16*t*(14 + 17*y0 + 5*Y2))) + 70*X4*(-(POW2(B)*(2 + y0)*(-32*T3 + 72*T2*(2 + y0) - 24*t*POW2(2 + y0) + POW3(2 + y0))) + 12*POW2(C)*(60*t*(1 + y0)*POW2(2 + y0) - POW3(2 + y0)*(2 + 3*y0) + 16*T3*(5 + 3*y0) - 48*T2*(8 + 10*y0 + 3*Y2)) + 4*B*C*(-(POW3(2 + y0)*(4 + 3*y0)) + 8*T3*(16 + 9*y0) + 6*t*POW2(2 + y0)*(16 + 11*y0) - 36*T2*(16 + 18*y0 + 5*Y2))) + 224*t*X5*(POW2(B)*(2*T3 - 12*T2*(2 + y0) + 9*t*POW2(2 + y0) - POW3(2 + y0)) + 6*POW2(C)*(6*T3 - 6*(1 + y0)*POW2(2 + y0) - 16*T2*(5 + 3*y0) + 15*t*(8 + 10*y0 + 3*Y2)) + 3*B*C*(6*T3 - 2*POW2(2 + y0)*(3 + 2*y0) - 8*T2*(9 + 5*y0) + 3*t*(36 + 40*y0 + 11*Y2))))/40320. );
}
float i2cell01_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (POW3(2 + x)*(POW2(B)*(2 + x)*(9*T4*(16 - 32*x + 40*X2 - 40*X3 + 35*X4) + 32*T3*(-2 + 4*x - 5*X2 + 5*X3)*(4 + 9*y0) + 56*T2*(2 - 4*x + 5*X2)*y0*(8 + 9*y0) + 112*t*(-1 + 2*x)*(-2 + 12*Y2 + 9*Y3) + 70*y0*(-8 + 16*Y2 + 9*Y3)) + 4*C*(3*(-2 + C)*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(-3 + C - 6*y0 + 3*C*y0) + 840*T2*X3*y0*(-6*(1 + y0) + C*(2 + 3*y0)) + 168*t*(-2 + 3*x + 12*X2)*(1 + y0)*(1 - y0 + (-2 + C)*Y2) + 70*(2 + 3*x)*(6 + 12*y0 + 4*(-3 + C)*Y3 + 3*(-2 + C)*Y4)) + 4*B*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 - 35*X5 + C*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 175*X5)) + 8*T3*(-6*(-4 + 6*x - 6*X2 + 5*X3 + 5*X4)*(1 + 2*y0) + C*(8 + 12*y0 - 6*x*(2 + 3*y0) + 6*X2*(2 + 3*y0) - 5*X3*(2 + 3*y0) + 10*X4*(13 + 30*y0))) + 56*T2*y0*(-3*(4 - 6*x + 6*X2 + 5*X3)*(1 + y0) + C*(4 + 6*y0 - 3*x*(2 + 3*y0) + X2*(6 + 9*y0) + X3*(65 + 75*y0))) + 28*t*(-6*(-2 + 3*x + 2*X2)*POW2(1 + y0)*(-1 + 2*y0) + C*(4 - 36*Y2 - 30*Y3 + 12*X2*(-2 + 13*Y2 + 10*Y3) + x*(-6 + 54*Y2 + 45*Y3))) + 70*(x*(3 + (6 - 12*C)*y0 + (-6 + 26*C)*Y3 + 3*(-1 + 5*C)*Y4) + 2*(3 + (6 - 4*C)*y0 + 2*(-3 + 5*C)*Y3 + (-3 + 6*C)*Y4)))))/40320. );
}
float i2cell11_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (3*T4*(3*POW2(B)*(216 - 112*X5 + 480*X7 + 315*X8) + 12*(POW2(C)*(-96 + 40*X7 + 35*X8) + 4*(-3 - 28*X5 + 60*X7 + 35*X8) - 2*C*(-99 - 28*X5 + 100*X7 + 70*X8)) + 4*B*(-189 + 364*X5 - 1020*X7 - 630*X8 + C*(-324 - 56*X5 + 420*X7 + 315*X8))) + 56*T2*(12*(1 + 5*X3 - 9*X5 - 5*X6) + 6*C*(-4 + 6*X5 + 5*X6) + B*(18 - 20*X3 + 72*X5 + 45*X6))*y0*(-12 + 8*B + 4*C - 12*y0 + 9*B*y0 + 6*C*y0) + 16*T3*(-15*(1 - 7*X4 + 14*X6 + 8*X7) + C*(92 + 70*X6 + 60*X7) + B*(-47 - 35*X4 + 140*X6 + 90*X7))*(B*(4 + 9*y0) + 2*(-3 + C - 6*y0 + 3*C*y0)) + 112*t*(6*(1 + y0)*(POW2(C)*(4 + 15*X4 + 12*X5)*Y2 + 3*POW3(1 + x)*(3 - 9*x + 8*X2)*(-1 + y0 + 2*Y2) - C*(-4 + 4*y0 + 17*Y2 - 30*X2*Y2 + 12*X5*(-1 + y0 + 4*Y2) + 15*X4*(-1 + y0 + 5*Y2))) + POW2(B)*(-5 - 10*X2 + 30*X4 + 18*X5)*(-2 + 12*Y2 + 9*Y3) + B*(C*(-8 + 18*Y2 - 60*X2*(1 + y0)*Y2 + 6*Y3 + 12*X5*(-2 + 21*Y2 + 18*Y3) + 15*X4*(-2 + 24*Y2 + 21*Y3)) - 3*(4 + 6*Y2 + 7*Y3 - 10*X2*(-4 + 18*Y2 + 13*Y3) + 15*X4*(-6 + 24*Y2 + 17*Y3) + 4*X5*(-13 + 51*Y2 + 36*Y3)))) + 70*(12*(12 - 8*(-3 + B)*y0 + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) - 8*(-3 + B)*x*(12 - 8*(-3 + B)*y0 + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) + 3*X4*(48*(-1 + y0)*POW3(1 + y0) + 4*POW2(C)*(4 + 3*y0)*Y3 + 3*POW2(B)*y0*(-8 + 16*Y2 + 9*Y3) - 8*C*(-3 - 6*y0 + 10*Y3 + 6*Y4) + 4*B*(9 + (26 - 4*C)*y0 + 2*(-17 + 7*C)*Y3 + 9*(-2 + C)*Y4)) + 8*X3*(36*(-1 + y0)*POW3(1 + y0) + 2*POW2(C)*(4 + 3*y0)*Y3 + 2*POW2(B)*y0*(-8 + 16*Y2 + 9*Y3) - 6*C*(-2 - 4*y0 + 8*Y3 + 5*Y4) + B*(24 - 8*(-9 + C)*y0 + 32*(-3 + C)*Y3 + 3*(-17 + 7*C)*Y4))))/40320. );
}
float i2cell21_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (4*(27*(-4 + 18*POW2(B) + 66*C - 32*POW2(C) - 3*B*(7 + 12*C))*T4 + 84*(2 + 3*B - 4*C)*T2*y0*(-12 + 8*B + 4*C - 12*y0 + 9*B*y0 + 6*C*y0) - 4*(15 + 47*B - 92*C)*T3*(B*(4 + 9*y0) + 2*(-3 + C - 6*y0 + 3*C*y0)) - 28*t*(-6*(1 + y0)*(C*(4 - 4*y0 - 17*Y2) + 4*POW2(C)*Y2 + 9*(-1 + y0 + 2*Y2)) + 5*POW2(B)*(-2 + 12*Y2 + 9*Y3) + B*(-2*C*(-4 + 9*Y2 + 3*Y3) + 3*(4 + 6*Y2 + 7*Y3))) + 210*(12 - 8*(-3 + B)*y0 + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4)) + x*(720*(6*POW2(B) + B*(-17 + 7*C) + 2*(6 - 5*C + POW2(C)))*T4*X6 - 315*POW2(-4 + 3*B + 2*C)*T4*X7 - 840*(-4 + 3*B + 2*C)*T2*X5*y0*(-12 + 8*B + 4*C - 12*y0 + 9*B*y0 + 6*C*y0) + 1120*(-3 + 2*B + C)*T3*X5*(B*(4 + 9*y0) + 2*(-3 + C - 6*y0 + 3*C*y0)) - 480*(-4 + 3*B + 2*C)*T3*X6*(B*(4 + 9*y0) + 2*(-3 + C - 6*y0 + 3*C*y0)) - 336*T2*X4*((-3 + B)*(-4 + 3*B + 2*C)*T2 - 6*(-3 + 2*B + C)*y0*(-12 + 8*B + 4*C - 12*y0 + 9*B*y0 + 6*C*y0)) - 1120*(-3 + B)*t*x*(6*(1 + y0)*(1 - y0 + (-2 + C)*Y2) + B*(-2 + 12*Y2 + 9*Y3)) - 560*t*X3*(B*(C*(6 + T2*(2 + 6*y0) - 72*Y2 - 63*Y3) - 3*(18 + T2*(6 + 13*y0) - 72*Y2 - 51*Y3)) - 6*(3*POW2(C)*(1 + y0)*Y2 + C*(3 + T2 + 3*T2*y0 - 18*Y2 - 15*Y3) - 3*(3 + T2 + 2*T2*y0 - 9*Y2 - 6*Y3)) + POW2(B)*(T2*(4 + 9*y0) - 6*(-2 + 12*Y2 + 9*Y3))) - 672*t*X4*(12*(1 + y0)*(-2 + C + 2*y0 - C*y0 + 4*Y2 - 4*C*Y2 + POW2(C)*Y2) + 3*POW2(B)*(-2 + 12*Y2 + 9*Y3) + 2*B*(13 - 51*Y2 - 36*Y3 + C*(-2 + 21*Y2 + 18*Y3))) - 560*(-3 + B)*(12 - 8*(-3 + B)*y0 + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) - 210*X3*(48*(-1 + y0)*POW3(1 + y0) + 4*POW2(C)*(4 + 3*y0)*Y3 + 3*POW2(B)*y0*(-8 + 16*Y2 + 9*Y3) - 8*C*(-3 - 6*y0 + 10*Y3 + 6*Y4) + 4*B*(9 + (26 - 4*C)*y0 + 2*(-17 + 7*C)*Y3 + 9*(-2 + C)*Y4)) + 560*X2*(2*POW2(C)*(4 + 3*y0)*Y3 + 36*(1 + y0)*(-1 - (1 + 2*T2)*y0 + Y2 + Y3) + 2*POW2(B)*y0*(-8 - T2*(8 + 9*y0) + 16*Y2 + 9*Y3) + 6*C*(2 + 4*(1 + T2)*y0 + 6*T2*Y2 - 8*Y3 - 5*Y4) + B*(24 - 8*(-9 + C)*(1 + T2)*y0 + 6*(13 - 2*C)*T2*Y2 + 32*(-3 + C)*Y3 + 3*(-17 + 7*C)*Y4))))/40320. );
}
float i2cell31_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (POW2(B)*(-9*T4*(-176 - 448*X5 + 560*X6 - 240*X7 + 35*X8) - 32*T3*POW4(-2 + x)*(2 + 4*x + 5*X2 + 5*X3)*(4 + 9*y0) - 56*T2*(-4 - 80*X3 + 90*X4 - 36*X5 + 5*X6)*y0*(8 + 9*y0) - 112*t*POW4(-2 + x)*(1 + 2*x)*(-2 + 12*Y2 + 9*Y3) - 70*POW4(-2 + x)*y0*(-8 + 16*Y2 + 9*Y3)) - 4*(72*(3*T4 + 56*T2*y0*(1 + y0) + 70*(-1 + y0)*POW3(1 + y0)) + POW2(C)*(3*T4*(320 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(1 + 3*y0) + 168*T2*(8 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*y0*(2 + 3*y0) + 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*(1 + y0)*Y2 + 70*POW3(-2 + x)*(-2 + 3*x)*(4 + 3*y0)*Y3) - 6*C*(T4*(338 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 28*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*POW2(1 + y0)*(-1 + 2*y0) + 8*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(1 + 2*y0) + 56*T2*y0*(28 + 30*y0 - 120*X3*(1 + y0) + 180*X4*(1 + y0) - 90*X5*(1 + y0) + 15*X6*(1 + y0)) + 70*(-16 - 32*y0 - 48*x*(-1 + y0)*POW3(1 + y0) + 48*X2*(-1 + y0)*POW3(1 + y0) - 20*X3*(-1 + y0)*POW3(1 + y0) + 3*X4*(-1 + y0)*POW3(1 + y0) + 40*Y3 + 22*Y4))) - 4*B*(3*T4*(122 + 448*X5 - 560*X6 + 240*X7 - 35*X8 + C*(392 - 1232*X5 + 1960*X6 - 1020*X7 + 175*X8)) + 8*T3*POW3(-2 + x)*(-6*(-4 - 6*x - 6*X2 - 5*X3 + 5*X4)*(1 + 2*y0) + C*(8 + 12*y0 + 6*x*(2 + 3*y0) + 6*X2*(2 + 3*y0) + 5*X3*(2 + 3*y0) + 10*X4*(13 + 30*y0))) + 56*T2*y0*(-3*(-80*X3*(1 + y0) + 90*X4*(1 + y0) - 36*X5*(1 + y0) + 5*X6*(1 + y0) + 2*(6 + 7*y0)) + C*(92 + 102*y0 + 135*X4*(6 + 7*y0) - 20*X3*(28 + 33*y0) - 9*X5*(44 + 51*y0) + X6*(65 + 75*y0))) + 28*t*POW3(-2 + x)*(-6*(-2 - 3*x + 2*X2)*POW2(1 + y0)*(-1 + 2*y0) + C*(4 - 36*Y2 + x*(6 - 54*Y2 - 45*Y3) - 30*Y3 + 12*X2*(-2 + 13*Y2 + 10*Y3))) + 70*(X4*(3 + (6 - 12*C)*y0 + (-6 + 26*C)*Y3 + 3*(-1 + 5*C)*Y4) + 12*X2*(6 - 4*(-3 + 4*C)*y0 + 12*(-1 + 3*C)*Y3 + 3*(-2 + 7*C)*Y4) - 8*x*(12 - 24*(-1 + C)*y0 + 8*(-3 + 7*C)*Y3 + 3*(-4 + 11*C)*Y4) - 2*X3*(12 - 8*(-3 + 5*C)*y0 + 8*(-3 + 11*C)*Y3 + 3*(-4 + 17*C)*Y4) + 2*(24 - 8*(-9 + 4*C)*y0 + 16*(-6 + 5*C)*Y3 + (-51 + 48*C)*Y4))))/40320. );
}
float i2cell02_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    -(POW3(2 + x)*(POW2(B)*(2 + x)*(9*T4*(16 - 32*x + 40*X2 - 40*X3 + 35*X4) + 56*T2*(2 - 4*x + 5*X2)*y0*(-8 + 9*y0) + 32*T3*(-2 + 4*x - 5*X2 + 5*X3)*(-4 + 9*y0) + 70*y0*(8 - 16*Y2 + 9*Y3) + 112*t*(-1 + 2*x)*(2 - 12*Y2 + 9*Y3)) + 4*C*(3*(-2 + C)*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 840*T2*X3*y0*(6 - 6*y0 + C*(-2 + 3*y0)) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(3 - 6*y0 + C*(-1 + 3*y0)) + 168*t*(-2 + 3*x + 12*X2)*(-1 + y0)*(1 + y0 + (-2 + C)*Y2) + 70*(2 + 3*x)*(-6 - 12*y0 - 4*(-3 + C)*Y3 + 3*(-2 + C)*Y4)) + 4*B*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 - 35*X5 + C*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 175*X5)) + 8*T3*(-6*(-4 + 6*x - 6*X2 + 5*X3 + 5*X4)*(-1 + 2*y0) + C*(-8 + 12*y0 - 6*x*(-2 + 3*y0) + 6*X2*(-2 + 3*y0) - 5*X3*(-2 + 3*y0) + 10*X4*(-13 + 30*y0))) + 56*T2*y0*(-3*(4 - 6*x + 6*X2 + 5*X3)*(-1 + y0) + C*(-4 + x*(6 - 9*y0) + 6*y0 + X2*(-6 + 9*y0) + X3*(-65 + 75*y0))) + 28*t*(-6*(-2 + 3*x + 2*X2)*POW2(-1 + y0)*(1 + 2*y0) + C*(-4 + 36*Y2 - 30*Y3 + 12*X2*(2 - 13*Y2 + 10*Y3) + x*(6 - 54*Y2 + 45*Y3))) + 70*(x*(-3 + 6*(-1 + 2*C)*y0 + (6 - 26*C)*Y3 + 3*(-1 + 5*C)*Y4) + 2*(-3 + (-6 + 4*C)*y0 + (6 - 10*C)*Y3 + (-3 + 6*C)*Y4)))))/40320. );
}
float i2cell12_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (-3*T4*(3*POW2(B)*(216 - 112*X5 + 480*X7 + 315*X8) + 12*(POW2(C)*(-96 + 40*X7 + 35*X8) + 4*(-3 - 28*X5 + 60*X7 + 35*X8) - 2*C*(-99 - 28*X5 + 100*X7 + 70*X8)) + 4*B*(-189 + 364*X5 - 1020*X7 - 630*X8 + C*(-324 - 56*X5 + 420*X7 + 315*X8))) - 56*T2*(12*(1 + 5*X3 - 9*X5 - 5*X6) + 6*C*(-4 + 6*X5 + 5*X6) + B*(18 - 20*X3 + 72*X5 + 45*X6))*y0*(12 - 8*B - 4*C - 12*y0 + 9*B*y0 + 6*C*y0) - 16*T3*(-15*(1 - 7*X4 + 14*X6 + 8*X7) + C*(92 + 70*X6 + 60*X7) + B*(-47 - 35*X4 + 140*X6 + 90*X7))*(6 - 12*y0 + C*(-2 + 6*y0) + B*(-4 + 9*y0)) - 112*t*(6*(-1 + y0)*(POW2(C)*(4 + 15*X4 + 12*X5)*Y2 + 3*POW3(1 + x)*(3 - 9*x + 8*X2)*(-1 - y0 + 2*Y2) + C*(4 + 4*y0 + 15*X4*(1 + y0 - 5*Y2) + 12*X5*(1 + y0 - 4*Y2) - 17*Y2 + 30*X2*Y2)) + POW2(B)*(-5 - 10*X2 + 30*X4 + 18*X5)*(2 - 12*Y2 + 9*Y3) + B*(C*(8 - 18*Y2 - 60*X2*(-1 + y0)*Y2 + 6*Y3 + 12*X5*(2 - 21*Y2 + 18*Y3) + 15*X4*(2 - 24*Y2 + 21*Y3)) - 3*(-4 - 6*Y2 + 7*Y3 - 10*X2*(4 - 18*Y2 + 13*Y3) + 15*X4*(6 - 24*Y2 + 17*Y3) + 4*X5*(13 - 51*Y2 + 36*Y3)))) - 70*(12*(-12 + 8*(-3 + B)*y0 - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) - 8*(-3 + B)*x*(-12 + 8*(-3 + B)*y0 - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) + 3*X4*(4*POW2(C)*(-4 + 3*y0)*Y3 + 3*POW2(B)*y0*(8 - 16*Y2 + 9*Y3) + 48*(1 + 2*y0 - 2*Y3 + Y4) - 8*C*(3 + 6*y0 - 10*Y3 + 6*Y4) + 4*B*(-9 + (-26 + 4*C)*y0 + (34 - 14*C)*Y3 + 9*(-2 + C)*Y4)) + 8*X3*(2*POW2(C)*(-4 + 3*y0)*Y3 + 2*POW2(B)*y0*(8 - 16*Y2 + 9*Y3) + 36*(1 + 2*y0 - 2*Y3 + Y4) - 6*C*(2 + 4*y0 - 8*Y3 + 5*Y4) + B*(-24 + 8*(-9 + C)*y0 - 32*(-3 + C)*Y3 + 3*(-17 + 7*C)*Y4))))/40320. );
}
float i2cell22_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (4*(-27*(-4 + 18*POW2(B) + 66*C - 32*POW2(C) - 3*B*(7 + 12*C))*T4 - 84*(2 + 3*B - 4*C)*T2*y0*(12 - 8*B - 4*C - 12*y0 + 9*B*y0 + 6*C*y0) + 4*(15 + 47*B - 92*C)*T3*(6 - 12*y0 + C*(-2 + 6*y0) + B*(-4 + 9*y0)) + 28*t*(-6*(-9 + 4*C)*(-1 + y0)*(1 + y0 + (-2 + C)*Y2) + 5*POW2(B)*(2 - 12*Y2 + 9*Y3) - B*(3*(4 + 6*Y2 - 7*Y3) + 2*C*(4 - 9*Y2 + 3*Y3))) - 210*(-12 + 8*(-3 + B)*y0 - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4)) + x*(-720*(6*POW2(B) + B*(-17 + 7*C) + 2*(6 - 5*C + POW2(C)))*T4*X6 + 315*POW2(-4 + 3*B + 2*C)*T4*X7 + 840*(-4 + 3*B + 2*C)*T2*X5*y0*(12 - 8*B - 4*C - 12*y0 + 9*B*y0 + 6*C*y0) - 1120*(-3 + 2*B + C)*T3*X5*(6 - 12*y0 + C*(-2 + 6*y0) + B*(-4 + 9*y0)) + 480*(-4 + 3*B + 2*C)*T3*X6*(6 - 12*y0 + C*(-2 + 6*y0) + B*(-4 + 9*y0)) + 336*T2*X4*((-3 + B)*(-4 + 3*B + 2*C)*T2 - 6*(-3 + 2*B + C)*y0*(12 - 8*B - 4*C - 12*y0 + 9*B*y0 + 6*C*y0)) + 1120*(-3 + B)*t*x*(6*(-1 + y0)*(1 + y0 + (-2 + C)*Y2) + B*(2 - 12*Y2 + 9*Y3)) + 672*t*X4*(12*(-2 + C)*(-1 + y0)*(1 + y0 + (-2 + C)*Y2) + 3*POW2(B)*(2 - 12*Y2 + 9*Y3) + 2*B*(-13 + 51*Y2 - 36*Y3 + C*(2 - 21*Y2 + 18*Y3))) + 560*t*X3*(-6*(C*T2*(-1 + 3*y0) + 3*POW2(C)*(-1 + y0)*Y2 - 3*C*(1 - 6*Y2 + 5*Y3) + 3*(3 + T2 - 2*T2*y0 - 9*Y2 + 6*Y3)) + POW2(B)*(T2*(-4 + 9*y0) - 6*(2 - 12*Y2 + 9*Y3)) + B*(C*(-6 + T2*(-2 + 6*y0) + 72*Y2 - 63*Y3) + 3*(18 + T2*(6 - 13*y0) - 72*Y2 + 51*Y3))) + 560*(-3 + B)*(-12 + 8*(-3 + B)*y0 - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) + 560*X2*(2*POW2(C)*(4 - 3*y0)*Y3 - 2*POW2(B)*y0*(8 + T2*(8 - 9*y0) - 16*Y2 + 9*Y3) - 36*(1 + 2*(1 + T2)*y0 - 2*T2*Y2 - 2*Y3 + Y4) + 6*C*(2 + 4*(1 + T2)*y0 - 6*T2*Y2 - 8*Y3 + 5*Y4) + B*(24 - 8*(-9 + C)*(1 + T2)*y0 + 6*(-13 + 2*C)*T2*Y2 + 32*(-3 + C)*Y3 + (51 - 21*C)*Y4)) + 210*X3*(4*POW2(C)*(-4 + 3*y0)*Y3 + 3*POW2(B)*y0*(8 - 16*Y2 + 9*Y3) + 48*(1 + 2*y0 - 2*Y3 + Y4) - 8*C*(3 + 6*y0 - 10*Y3 + 6*Y4) + 4*B*(-9 + (-26 + 4*C)*y0 + (34 - 14*C)*Y3 + 9*(-2 + C)*Y4))))/40320. );
}
float i2cell32_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (POW2(B)*(9*T4*(-176 - 448*X5 + 560*X6 - 240*X7 + 35*X8) + 56*T2*(-4 - 80*X3 + 90*X4 - 36*X5 + 5*X6)*y0*(-8 + 9*y0) + 32*T3*POW4(-2 + x)*(2 + 4*x + 5*X2 + 5*X3)*(-4 + 9*y0) + 70*POW4(-2 + x)*y0*(8 - 16*Y2 + 9*Y3) + 112*t*POW4(-2 + x)*(1 + 2*x)*(2 - 12*Y2 + 9*Y3)) + 4*B*(3*T4*(122 + 448*X5 - 560*X6 + 240*X7 - 35*X8 + C*(392 - 1232*X5 + 1960*X6 - 1020*X7 + 175*X8)) + 8*T3*POW3(-2 + x)*(-6*(-4 - 6*x - 6*X2 - 5*X3 + 5*X4)*(-1 + 2*y0) + C*(-8 + 12*y0 + 6*x*(-2 + 3*y0) + 6*X2*(-2 + 3*y0) + 5*X3*(-2 + 3*y0) + 10*X4*(-13 + 30*y0))) + 56*T2*y0*(-3*(-80*X3*(-1 + y0) + 90*X4*(-1 + y0) - 36*X5*(-1 + y0) + 5*X6*(-1 + y0) + 2*(-6 + 7*y0)) + C*(-92 + X3*(560 - 660*y0) + 102*y0 + 135*X4*(-6 + 7*y0) - 9*X5*(-44 + 51*y0) + X6*(-65 + 75*y0))) + 28*t*POW3(-2 + x)*(-6*(-2 - 3*x + 2*X2)*POW2(-1 + y0)*(1 + 2*y0) + C*(-4 + 36*Y2 + x*(-6 + 54*Y2 - 45*Y3) - 30*Y3 + 12*X2*(2 - 13*Y2 + 10*Y3))) + 70*(X4*(-3 + 6*(-1 + 2*C)*y0 + (6 - 26*C)*Y3 + 3*(-1 + 5*C)*Y4) + 12*X2*(-6 + 4*(-3 + 4*C)*y0 + (12 - 36*C)*Y3 + 3*(-2 + 7*C)*Y4) - 8*x*(-12 + 24*(-1 + C)*y0 - 8*(-3 + 7*C)*Y3 + 3*(-4 + 11*C)*Y4) + X3*(24 + (48 - 80*C)*y0 + 16*(-3 + 11*C)*Y3 - 6*(-4 + 17*C)*Y4) + 2*(-24 + 8*(-9 + 4*C)*y0 + (96 - 80*C)*Y3 + (-51 + 48*C)*Y4))) + 4*(POW2(C)*(3*T4*(320 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 168*T2*(8 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*y0*(-2 + 3*y0) + 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(-1 + 3*y0) + 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*(-1 + y0)*Y2 + 70*POW3(-2 + x)*(-2 + 3*x)*(-4 + 3*y0)*Y3) + 72*(3*T4 + 56*T2*(-1 + y0)*y0 + 70*(1 + 2*y0 - 2*Y3 + Y4)) - 6*C*(T4*(338 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 8*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(-1 + 2*y0) + 28*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*POW2(-1 + y0)*(1 + 2*y0) + 56*T2*y0*(-28 - 120*X3*(-1 + y0) + 180*X4*(-1 + y0) - 90*X5*(-1 + y0) + 15*X6*(-1 + y0) + 30*y0) + 70*(16 + 32*y0 - 40*Y3 + 22*Y4 - 48*x*(1 + 2*y0 - 2*Y3 + Y4) + 48*X2*(1 + 2*y0 - 2*Y3 + Y4) - 20*X3*(1 + 2*y0 - 2*Y3 + Y4) + 3*X4*(1 + 2*y0 - 2*Y3 + Y4)))))/40320. );
}
float i2cell03_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (POW3(2 + x)*(1680*B*(2 + x) - POW2(B)*(2 + x)*(T4*(16 - 32*x + 40*X2 - 40*X3 + 35*X4) + 32*T3*(-2 + 4*x - 5*X2 + 5*X3)*(-2 + y0) + 56*T2*(2 - 4*x + 5*X2)*POW2(-2 + y0) + 112*t*(-1 + 2*x)*POW3(-2 + y0) + 70*POW4(-2 + y0)) - 4*B*C*(T4*(32 - 48*x + 48*X2 - 40*X3 + 30*X4 + 105*X5) + 70*POW3(-2 + y0)*(-4 - 4*x + 4*y0 + 3*x*y0) + 8*T3*(32 - 20*y0 + 6*x*(-8 + 5*y0) - 6*X2*(-8 + 5*y0) + 5*X3*(-8 + 5*y0) + 10*X4*(-11 + 6*y0)) + 28*t*POW2(-2 + y0)*(16 - 14*y0 + 12*X2*(-3 + 2*y0) + 3*x*(-8 + 7*y0)) + 56*T2*(16 - 20*y0 + 6*Y2 + 5*X3*(10 - 11*y0 + 3*Y2) - 3*x*(8 - 10*y0 + 3*Y2) + 3*X2*(8 - 10*y0 + 3*Y2))) - 4*C*(-840*(2 + 3*x) + C*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 168*t*(-2 + 3*x + 12*X2)*POW2(-2 + y0)*(-1 + y0) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(-5 + 3*y0) + 70*(2 + 3*x)*POW3(-2 + y0)*(-2 + 3*y0) + 840*T2*X3*(8 - 10*y0 + 3*Y2)))))/40320. );
}
float i2cell13_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (-(POW2(B)*(T4*(216 - 112*X5 + 480*X7 + 315*X8) + 16*T3*(-47 - 35*X4 + 140*X6 + 90*X7)*(-2 + y0) + 56*T2*(18 - 20*X3 + 72*X5 + 45*X6)*POW2(-2 + y0) + 112*t*(-5 - 10*X2 + 30*X4 + 18*X5)*POW3(-2 + y0) + 70*x*(-8 + 16*X2 + 9*X3)*POW4(-2 + y0))) - 4*B*(3*T4*(3 + 28*X5 - 60*X7 - 35*X8 + C*(60 - 56*X5 + 260*X7 + 175*X8)) + 4*T3*(-15*POW3(1 + x)*(1 - 3*x + 6*X2 - 10*X3 + 8*X4)*(-2 + y0) + 2*C*(143 - 95*y0 - 35*X4*(-5 + 3*y0) + 30*X7*(-17 + 10*y0) + 35*X6*(-22 + 13*y0))) + 56*T2*(-2 + y0)*(-3*POW3(1 + x)*(-1 + 3*x - 6*X2 + 5*X3)*(-2 + y0) + C*(X3*(40 - 30*y0) + 15*X6*(-7 + 5*y0) + 3*(-8 + 7*y0) + 9*X5*(-18 + 13*y0))) + 28*t*POW2(-2 + y0)*(-3*POW3(1 + x)*(3 - 9*x + 8*X2)*(-2 + y0) + C*(22 - 60*X2*(-1 + y0) - 26*y0 + 12*X5*(-11 + 10*y0) + 15*X4*(-14 + 13*y0))) + 70*(3*POW4(-2 + y0) - 4*C*x*POW3(-2 + y0)*(-2 + 3*y0) + 3*X4*(-34 + 32*y0 + C*POW3(-2 + y0)*(-4 + 5*y0) - 24*Y2 + 8*Y3 - Y4) + 6*x*(24 - 32*y0 + 24*Y2 - 8*Y3 + Y4) + 2*X3*(C*POW3(-2 + y0)*(-10 + 13*y0) - 3*(32 - 32*y0 + 24*Y2 - 8*Y3 + Y4)))) - 4*(5040*(-1 + x)*POW3(1 + x) + POW2(C)*(9*T4*(-96 + 40*X7 + 35*X8) + 168*t*(4 + 15*X4 + 12*X5)*POW2(-2 + y0)*(-1 + y0) + 16*T3*(46 + 35*X6 + 30*X7)*(-5 + 3*y0) + 70*(4 + 3*x)*X3*POW3(-2 + y0)*(-2 + 3*y0) + 168*T2*(-4 + 6*X5 + 5*X6)*(8 - 10*y0 + 3*Y2)) - 6*C*(3*T4*(-3 - 28*X5 + 60*X7 + 35*X8) + 84*t*POW3(1 + x)*(3 - 9*x + 8*X2)*POW2(-2 + y0)*(-1 + y0) + 20*T3*POW3(1 + x)*(1 - 3*x + 6*X2 - 10*X3 + 8*X4)*(-5 + 3*y0) + 56*T2*POW3(1 + x)*(-1 + 3*x - 6*X2 + 5*X3)*(8 - 10*y0 + 3*Y2) + 70*(-(POW3(-2 + y0)*(-2 + 3*y0)) - 2*x*POW3(-2 + y0)*(-2 + 3*y0) + X4*(22 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4) + X3*(40 - 96*y0 + 96*Y2 - 40*Y3 + 6*Y4)))))/40320. );
}
float i2cell23_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (4*(5040 - 2*POW2(B)*t*(27*T3 - 94*T2*(-2 + y0) + 126*t*POW2(-2 + y0) - 70*POW3(-2 + y0)) - B*(9*(1 + 20*C)*T4 + 210*POW4(-2 + y0) + 168*T2*(-2 + y0)*(-2 + y0 + C*(-8 + 7*y0)) - 28*t*POW2(-2 + y0)*(9*(-2 + y0) + C*(-22 + 26*y0)) - 4*T3*(15*(-2 + y0) + 2*C*(-143 + 95*y0))) + 32*POW2(C)*t*(27*T3 - 21*POW2(-2 + y0)*(-1 + y0) - 23*T2*(-5 + 3*y0) + 21*t*(8 - 10*y0 + 3*Y2)) - 6*C*(9*T4 - 252*t*POW2(-2 + y0)*(-1 + y0) - 20*T3*(-5 + 3*y0) + 70*POW3(-2 + y0)*(-2 + 3*y0) + 56*T2*(8 - 10*y0 + 3*Y2))) + x*(-240*(2*POW2(B) + 6*(-3 + C)*C + B*(-3 + 13*C))*T4*X6 + 105*(3*POW2(B) + 12*(-2 + C)*C + 4*B*(-1 + 5*C))*T4*X7 + 1120*(-3 + B)*t*x*(B*(-2 + y0) + 6*C*(-1 + y0))*POW2(-2 + y0) + 672*(-4 + 3*B + 2*C)*t*X4*(B*(-2 + y0) + 6*C*(-1 + y0))*POW2(-2 + y0) - 1120*(-3 + 2*B + C)*T3*X5*(B*(-2 + y0) + 2*C*(-5 + 3*y0)) + 480*(-4 + 3*B + 2*C)*T3*X6*(B*(-2 + y0) + 2*C*(-5 + 3*y0)) + 840*(-4 + 3*B + 2*C)*T2*X5*(-2 + y0)*(B*(-2 + y0) + 2*C*(-4 + 3*y0)) + 560*(-3 + B)*(-24 + B*POW4(-2 + y0) + 2*C*POW3(-2 + y0)*(-2 + 3*y0)) + 560*t*X3*(POW2(B)*(T2 - 6*POW2(-2 + y0))*(-2 + y0) - 6*C*(-9*POW2(-2 + y0)*(-1 + y0) + 3*C*POW2(-2 + y0)*(-1 + y0) + T2*(-5 + 3*y0)) + B*(-3*(T2 - 3*POW2(-2 + y0))*(-2 + y0) + 2*C*T2*(-5 + 3*y0) - 3*C*POW2(-2 + y0)*(-14 + 13*y0))) + 112*T2*X4*(POW2(B)*(T2 - 36*POW2(-2 + y0)) + 3*B*(-T2 + 18*POW2(-2 + y0) + 2*C*(-108 + T2 + 132*y0 - 39*Y2)) - 18*C*(-48 + T2 + 60*y0 - 18*Y2 + 2*C*(8 - 10*y0 + 3*Y2))) + 210*X3*(3*POW2(B)*POW4(-2 + y0) + 4*(24 + POW2(C)*POW3(-2 + y0)*(-2 + 3*y0) + C*(-44 + 96*y0 - 96*Y2 + 40*Y3 - 6*Y4)) + 4*B*(-34 + 32*y0 + C*POW3(-2 + y0)*(-4 + 5*y0) - 24*Y2 + 8*Y3 - Y4)) + 560*X2*(-72 + 2*POW2(B)*(T2 - POW2(-2 + y0))*POW2(-2 + y0) - 2*POW2(C)*POW3(-2 + y0)*(-2 + 3*y0) + B*C*(-2 + y0)*(4*T2*(-4 + 3*y0) - POW2(-2 + y0)*(-10 + 13*y0)) - 6*C*(-20 + 48*y0 - 48*Y2 + 2*T2*(8 - 10*y0 + 3*Y2) + 20*Y3 - 3*Y4) + 3*B*(32 - 2*T2*POW2(-2 + y0) - 32*y0 + 24*Y2 - 8*Y3 + Y4))))/40320. );
}
float i2cell33_BC(float x, float t, float y0) {
    return float( dFloat(1.) *
    (40320 + POW2(B)*(T4*(-176 - 448*X5 + 560*X6 - 240*X7 + 35*X8) + 32*T3*POW4(-2 + x)*(2 + 4*x + 5*X2 + 5*X3)*(-2 + y0) + 56*T2*(-4 - 80*X3 + 90*X4 - 36*X5 + 5*X6)*POW2(-2 + y0) + 112*t*POW4(-2 + x)*(1 + 2*x)*POW3(-2 + y0) + 70*POW4(-2 + x)*POW4(-2 + y0)) + 4*POW2(C)*(3*T4*(320 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*POW2(-2 + y0)*(-1 + y0) + 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(-5 + 3*y0) + 70*POW3(-2 + x)*(-2 + 3*x)*POW3(-2 + y0)*(-2 + 3*y0) + 168*T2*(8 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*(8 - 10*y0 + 3*Y2)) - 48*C*(9*T4 + 56*T2*(8 - 10*y0 + 3*Y2) + 70*(32 - 48*x + 48*X2 - 20*X3 + 3*X4 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4)) + 4*B*(C*(T4*(-104 - 1008*X5 + 1400*X6 - 660*X7 + 105*X8) + 70*POW3(-2 + x)*POW3(-2 + y0)*(4 - 4*y0 + x*(-4 + 3*y0)) + 8*T3*POW3(-2 + x)*(32 - 20*y0 - 6*x*(-8 + 5*y0) - 6*X2*(-8 + 5*y0) - 5*X3*(-8 + 5*y0) + 10*X4*(-11 + 6*y0)) + 28*t*POW3(-2 + x)*POW2(-2 + y0)*(16 - 14*y0 + 12*X2*(-3 + 2*y0) - 3*x*(-8 + 7*y0)) + 56*T2*(32 - 28*y0 + 6*Y2 + 5*X6*(10 - 11*y0 + 3*Y2) + 45*X4*(16 - 18*y0 + 5*Y2) - 20*X3*(28 - 32*y0 + 9*Y2) - 9*X5*(36 - 40*y0 + 11*Y2))) - 6*(3*T4 + 56*T2*POW2(-2 + y0) + 70*(32 - 32*x + 24*X2 - 8*X3 + X4 - 32*y0 + 24*Y2 - 8*Y3 + Y4))))/40320. );
}

#pragma endregion

#pragma region horizontal cell borders constant expressions
// generated with cubicMitchellBC-generic-mm113.nb

float HygxBorder04_BC(float t, float y0) {
    return float( dFloat(1.) *
    (POW6(-2 - 2*t + y0)*(POW2(B)*POW2(-2 - 2*t + y0) - 4*POW2(C)*(12 + 12*T2 + 12*y0 + 4*t*(-8 + 3*y0) - 9*Y2) + 4*B*C*(4 + 4*T2 - 8*t*(-1 + y0) - 8*y0 + 3*Y2)))/(40320.*POW4(t)) );
}
float HygxBorder14_BC(float t, float y0) {
    return float( dFloat(1.) *
    (216*POW2(B)*T8 - 752*POW2(B)*T7*(-2 + y0) + 1680*B*(8*T3 - 16*t*POW2(-2 + y0) + 9*POW3(-2 + y0))*(-2 + y0) + 1008*POW2(B)*T6*POW2(-2 + y0) - 560*POW2(B)*T5*POW3(-2 + y0) - 3360*C*(6 + 4*t - 3*y0)*POW3(-2 + y0) + 112*POW2(B)*T3*POW5(-2 + y0) - 32*POW2(B)*t*POW7(-2 + y0) + 9*POW2(B)*POW8(-2 + y0) - 4*POW2(C)*(864*T8 - 672*T5*POW2(-2 + y0)*(-1 + y0) - 736*T7*(-5 + 3*y0) + 8*t*POW6(-2 + y0)*(1 + 3*y0) - 3*POW7(-2 + y0)*(2 + 3*y0) + 672*T6*(8 - 10*y0 + 3*Y2)) + 4*B*C*(180*T8 + 56*T3*POW4(-2 + y0)*(-1 + 3*y0) + 3*POW7(-2 + y0)*(2 + 5*y0) - 56*T5*POW2(-2 + y0)*(-11 + 13*y0) - 4*t*POW6(-2 + y0)*(2 + 13*y0) - 8*T7*(-143 + 95*y0) + 168*T6*(16 - 22*y0 + 7*Y2)) + 24*C*(9*T8 - 252*T5*POW2(-2 + y0)*(-1 + y0) - 20*T7*(-5 + 3*y0) + 70*T4*POW3(-2 + y0)*(-2 + 3*y0) - 28*T3*POW4(-2 + y0)*(-1 + 3*y0) + 56*T6*(8 - 10*y0 + 3*Y2) + 4*t*POW3(-2 + y0)*(132 - 12*y0 + 30*Y2 - 17*Y3 + 3*Y4) - POW4(-2 + y0)*(404 + 24*Y2 - 16*Y3 + 3*Y4)) + 12*B*(3*T8 - 20*T7*(-2 + y0) + 56*T6*POW2(-2 + y0) - 84*T5*POW3(-2 + y0) + 70*T4*POW4(-2 + y0) + 4*t*POW3(-2 + y0)*(576 - 32*y0 + 24*Y2 - 8*Y3 + Y4) - POW4(-2 + y0)*(1276 - 32*y0 + 24*Y2 - 8*Y3 + Y4) - 28*T3*(-112 + 120*y0 - 80*Y2 + 40*Y3 - 10*Y4 + Y5)))/(40320.*POW4(t)) );
}
float HygxBorder24_BC(float t, float y0) {
    return float( dFloat(1.) *
    0.5 + ((24 - (B*(8*T3 - 16*t*POW2(-2 + y0) - 9*POW3(-2 + y0)))/POW3(t) + (8*(-3 + C)*POW2(-2 + y0))/POW2(t) + (6*(-2 + C)*POW3(-2 + y0))/POW3(t))*(2 - y0))/(24.*t) - (POW2(B)*(-216*T8 + 752*T7*(-2 + y0) - 1008*T6*POW2(-2 + y0) + 560*T5*POW3(-2 + y0) - 112*T3*POW5(-2 + y0) + 32*t*POW7(-2 + y0) + 9*POW8(-2 + y0)) + 4*(5040*(T4 - 2*T3*(-2 + y0) + 2*t*POW3(-2 + y0) + POW4(-2 + y0)) + POW2(C)*(864*T8 - 672*T5*POW2(-2 + y0)*(-1 + y0) - 736*T7*(-5 + 3*y0) + 8*t*POW6(-2 + y0)*(1 + 3*y0) + 3*POW7(-2 + y0)*(2 + 3*y0) + 672*T6*(8 - 10*y0 + 3*Y2)) - 6*C*(9*T8 - 252*T5*POW2(-2 + y0)*(-1 + y0) - 20*T7*(-5 + 3*y0) + 70*T4*POW3(-2 + y0)*(-2 + 3*y0) - 28*T3*POW4(-2 + y0)*(-1 + 3*y0) + 56*T6*(8 - 10*y0 + 3*Y2) + 4*t*POW3(-2 + y0)*(132 - 12*y0 + 30*Y2 - 17*Y3 + 3*Y4) + POW4(-2 + y0)*(404 + 24*Y2 - 16*Y3 + 3*Y4))) - 4*B*(C*(180*T8 + 56*T3*POW4(-2 + y0)*(-1 + 3*y0) - 3*POW7(-2 + y0)*(2 + 5*y0) - 56*T5*POW2(-2 + y0)*(-11 + 13*y0) - 4*t*POW6(-2 + y0)*(2 + 13*y0) - 8*T7*(-143 + 95*y0) + 168*T6*(16 - 22*y0 + 7*Y2)) + 3*(3*T8 - 20*T7*(-2 + y0) + 56*T6*POW2(-2 + y0) - 84*T5*POW3(-2 + y0) + 70*T4*POW4(-2 + y0) + 4*t*POW3(-2 + y0)*(576 - 32*y0 + 24*Y2 - 8*Y3 + Y4) + POW4(-2 + y0)*(1276 - 32*y0 + 24*Y2 - 8*Y3 + Y4) - 28*T3*(-112 + 120*y0 - 80*Y2 + 40*Y3 - 10*Y4 + Y5))))/(40320.*POW4(t)) );
}
float HygxBorder34_BC(float t, float y0) {
    return float( dFloat(1.) *
    -(40320*T4 + POW2(B)*(-176*T8 + 1024*T7*(-2 + y0) - 224*T6*POW2(-2 + y0) + 1792*T5*POW3(-2 + y0) + 1120*T4*POW4(-2 + y0) + 448*T3*POW5(-2 + y0) + 112*T2*POW6(-2 + y0) + 16*t*POW7(-2 + y0) + POW8(-2 + y0)) + 1680*(-24*T4 + B*POW4(-2 + 2*t + y0) + 2*C*POW3(-2 + 2*t + y0)*(-6 + 2*t + 3*y0)) + 4*POW2(C)*(960*T8 + 2688*T5*POW2(-2 + y0)*(-1 + y0) + 672*T2*POW5(-2 + y0)*y0 - 512*T7*(-5 + 3*y0) + 1120*T4*POW3(-2 + y0)*(-2 + 3*y0) + 672*T3*POW4(-2 + y0)*(-1 + 3*y0) + 40*t*POW6(-2 + y0)*(1 + 3*y0) + 3*POW7(-2 + y0)*(2 + 3*y0) + 1344*T6*(8 - 10*y0 + 3*Y2)) - 48*C*(9*T8 + 3360*T3*(-2 + y0) + 3360*T2*POW2(-2 + y0) + 1400*t*POW3(-2 + y0) + 210*POW4(-2 + y0) + 56*T6*(8 - 10*y0 + 3*Y2) + 70*T4*(32 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4)) - 4*B*(C*(104*T8 - 2240*T4*POW3(-2 + y0)*(-1 + y0) - POW7(-2 + y0)*(-2 + 3*y0) - 256*T7*(-8 + 5*y0) - 56*T2*POW5(-2 + y0)*(-4 + 5*y0) - 448*T5*POW2(-2 + y0)*(-8 + 7*y0) - 112*T3*POW4(-2 + y0)*(-8 + 9*y0) - 4*t*POW6(-2 + y0)*(-8 + 11*y0) - 112*T6*(16 - 14*y0 + 3*Y2)) + 6*(3*T8 + 2240*T3*(-2 + y0) + 1680*T2*POW2(-2 + y0) + 56*T6*POW2(-2 + y0) + 560*t*POW3(-2 + y0) + 70*POW4(-2 + y0) + 70*T4*(32 - 32*y0 + 24*Y2 - 8*Y3 + Y4))))/(40320.*POW4(t)) );
}
float HygxBorder03_BC(float t, float y0) {
    return float( dFloat(1.) *
    (POW6(-1 - 2*t + y0)*(2*POW2(B)*(-5 + 4*T2 + 4*y0 - 4*t*(2 + y0) + Y2) + 2*C*(12*T2 + 12*t*(-2 + y0) + 16*C*(-3 + t + 3*y0) - 9*(-3 + 2*y0 + Y2)) + B*(-4*C*(19 + 4*T2 - 16*y0 + t*(-2 + 4*y0) - 3*Y2) - 3*(-3 + 4*T2 + 2*y0 - 4*t*(1 + y0) + Y2))))/(10080.*POW4(t)) );
}
float HygxBorder13_BC(float t, float y0) {
    return float( dFloat(1.) *
    (32*POW2(C)*(92*T7 - 168*T6*(-1 + y0) + 84*T5*POW2(-1 + y0) - 7*t*POW6(-1 + y0) + 3*POW7(-1 + y0)) - 36*POW6(1 + t - y0)*(3 + 3*T2 - 2*y0 - 2*t*(4 + y0) - Y2) + 2*POW2(B)*(216*T8 + 9*POW7(-1 + y0)*(5 + y0) - 188*T7*(-1 + 4*y0) - 140*T5*POW2(-1 + y0)*(5 + 4*y0) + 28*T3*POW4(-1 + y0)*(11 + 4*y0) - 8*t*POW6(-1 + y0)*(17 + 4*y0) + 504*T6*(-1 - y0 + 2*Y2)) + 6*C*(288*T8 + 1120*T4*POW3(-1 + y0) - 560*T3*POW4(-1 + y0) - 224*T5*POW2(-1 + y0)*(5 + y0) + 4*t*POW6(-1 + y0)*(33 + 2*y0) - POW7(-1 + y0)*(41 + 3*y0) - 32*T7*(-9 + 23*y0) + 224*T6*(-2 - y0 + 3*Y2)) - B*(4*C*(288*T8 + T7*(560 - 736*y0) + 672*T6*POW2(-1 + y0) - 280*T3*POW4(-1 + y0) - 3*POW7(-1 + y0)*(17 + y0) - 112*T5*POW2(-1 + y0)*(-5 + 2*y0) + 2*t*POW6(-1 + y0)*(73 + 4*y0)) + 3*(192*T8 + T7*(336 - 592*y0) - 560*T4*POW3(-1 + y0)*(2 + y0) + 112*T5*POW2(-1 + y0)*(5 + y0) + 112*T3*POW4(-1 + y0)*(7 + 3*y0) - 8*t*POW6(-1 + y0)*(27 + 8*y0) + POW7(-1 + y0)*(67 + 17*y0) + 112*T6*(2 - 7*y0 + 5*Y2))))/(10080.*POW4(t)) );
}
float HygxBorder23_BC(float t, float y0) {
    return float( dFloat(1.) *
    (32*POW2(C)*(92*T7 - 168*T6*(-1 + y0) + 84*T5*POW2(-1 + y0) - 7*t*POW6(-1 + y0) - 3*POW7(-1 + y0)) - 36*(3*T8 + T7*(10 - 20*y0) + 56*T6*(-1 + y0)*y0 + 70*T4*POW3(-1 + y0)*(1 + y0) + POW7(-1 + y0)*(3 + y0) - 42*T5*POW2(-1 + y0)*(1 + 2*y0) - 14*T3*POW4(-1 + y0)*(3 + 2*y0) + 2*t*POW6(-1 + y0)*(5 + 2*y0)) + 2*POW2(B)*(216*T8 - 9*POW7(-1 + y0)*(5 + y0) - 188*T7*(-1 + 4*y0) - 140*T5*POW2(-1 + y0)*(5 + 4*y0) + 28*T3*POW4(-1 + y0)*(11 + 4*y0) - 8*t*POW6(-1 + y0)*(17 + 4*y0) + 504*T6*(-1 - y0 + 2*Y2)) + 6*C*(288*T8 + 1120*T4*POW3(-1 + y0) - 560*T3*POW4(-1 + y0) - 224*T5*POW2(-1 + y0)*(5 + y0) + 4*t*POW6(-1 + y0)*(33 + 2*y0) + POW7(-1 + y0)*(41 + 3*y0) - 32*T7*(-9 + 23*y0) + 224*T6*(-2 - y0 + 3*Y2)) - B*(4*C*(288*T8 + T7*(560 - 736*y0) + 672*T6*POW2(-1 + y0) - 280*T3*POW4(-1 + y0) + 3*POW7(-1 + y0)*(17 + y0) - 112*T5*POW2(-1 + y0)*(-5 + 2*y0) + 2*t*POW6(-1 + y0)*(73 + 4*y0)) + 3*(192*T8 + T7*(336 - 592*y0) - 560*T4*POW3(-1 + y0)*(2 + y0) + 112*T5*POW2(-1 + y0)*(5 + y0) + 112*T3*POW4(-1 + y0)*(7 + 3*y0) - 8*t*POW6(-1 + y0)*(27 + 8*y0) - POW7(-1 + y0)*(67 + 17*y0) + 112*T6*(2 - 7*y0 + 5*Y2))))/(10080.*POW4(t)) );
}
float HygxBorder33_BC(float t, float y0) {
    return float( dFloat(1.) *
    (32*POW2(C)*(64*T7 - 336*T6*(-1 + y0) - 336*T5*POW2(-1 + y0) - 560*T4*POW3(-1 + y0) - 420*T3*POW4(-1 + y0) - 168*T2*POW5(-1 + y0) - 35*t*POW6(-1 + y0) - 3*POW7(-1 + y0)) - 72*T4*(3*T4 + 56*T2*(-1 + y0)*y0 + 70*POW3(-1 + y0)*(1 + y0)) + 2*POW2(B)*(176*T8 - 1120*T4*POW3(-1 + y0)*(2 + y0) - POW7(-1 + y0)*(5 + y0) - 56*T2*POW5(-1 + y0)*(7 + 2*y0) - 256*T7*(-1 + 4*y0) - 448*T5*POW2(-1 + y0)*(5 + 4*y0) - 112*T3*POW4(-1 + y0)*(11 + 4*y0) - 4*t*POW6(-1 + y0)*(17 + 4*y0) + 112*T6*(-1 - y0 + 2*Y2)) + 6*C*(320*T8 + 224*T2*POW5(-1 + y0)*(2 + y0) + 1120*T4*POW3(-1 + y0)*(3 + y0) + 3*POW7(-1 + y0)*(3 + y0) - 256*T7*(-1 + 2*y0) + 448*T5*POW2(-1 + y0)*(1 + 2*y0) + 336*T3*POW4(-1 + y0)*(3 + 2*y0) + 20*t*POW6(-1 + y0)*(5 + 2*y0) + 448*T6*(-2 - y0 + 3*Y2)) - B*(4*C*(320*T8 + 1120*T4*POW3(-1 + y0)*(4 + y0) + 224*T2*POW5(-1 + y0)*(5 + y0) + POW7(-1 + y0)*(19 + 3*y0) - 128*T7*(-5 + 4*y0) + 224*T5*POW2(-1 + y0)*(17 + 4*y0) + 56*T3*POW4(-1 + y0)*(53 + 12*y0) + 2*t*POW6(-1 + y0)*(113 + 20*y0) + 448*T6*(-1 - 2*y0 + 3*Y2)) + 3*(128*T8 - 112*T2*POW5(-1 + y0)*(2 + y0) - POW7(-1 + y0)*(3 + y0) - 512*T7*(-1 + 2*y0) - 896*T5*POW2(-1 + y0)*(1 + 2*y0) - 1120*T4*POW3(-1 + y0)*(3 + 2*y0) - 224*T3*POW4(-1 + y0)*(3 + 2*y0) - 8*t*POW6(-1 + y0)*(5 + 2*y0) - 224*T6*(-2 - y0 + 3*Y2))))/(10080.*POW4(t)) );
}
float HygxBorder02_BC(float t, float y0) {
    return float( dFloat(1.) *
    -((-4 + 3*B + 2*C)*POW7(2*t - y0)*(2*B*t - 4*C*t - B*y0 - 6*C*y0))/(6720.*POW4(t)) );
}
float HygxBorder12_BC(float t, float y0) {
    return float( dFloat(1.) *
    -(36*(-4 + 18*POW2(B) + 66*C - 32*POW2(C) - 3*B*(7 + 12*C))*T8 - 16*(-60 + 141*POW2(B) + 398*C - 184*POW2(C) - 13*B*(11 + 14*C))*T7*y0 + 336*(-8 + 9*POW2(B) + 20*C - 8*POW2(C) - 6*B*(1 + C))*T6*Y2 - 112*(-36 + 15*POW2(B) + B*(7 - 2*C) + 34*C - 8*POW2(C))*T5*Y3 + 840*(-4 + 3*B + 2*C)*T4*Y4 + 112*(-3 + B)*(-4 + 3*B + 2*C)*T3*Y5 - 16*(6*POW2(B) + B*(-17 + 7*C) + 2*(6 - 5*C + POW2(C)))*t*Y7 + 3*POW2(-4 + 3*B + 2*C)*Y8)/(6720.*POW4(t)) );
}
float HygxBorder22_BC(float t, float y0) {
    return float( dFloat(1.) *
    (-36*(-4 + 18*POW2(B) + 66*C - 32*POW2(C) - 3*B*(7 + 12*C))*T8 + 16*(-60 + 141*POW2(B) + 398*C - 184*POW2(C) - 13*B*(11 + 14*C))*T7*y0 - 336*(-8 + 9*POW2(B) + 20*C - 8*POW2(C) - 6*B*(1 + C))*T6*Y2 + 112*(-36 + 15*POW2(B) + B*(7 - 2*C) + 34*C - 8*POW2(C))*T5*Y3 - 840*(-4 + 3*B + 2*C)*T4*Y4 - 112*(-3 + B)*(-4 + 3*B + 2*C)*T3*Y5 + 16*(6*POW2(B) + B*(-17 + 7*C) + 2*(6 - 5*C + POW2(C)))*t*Y7 + 3*POW2(-4 + 3*B + 2*C)*Y8)/(6720.*POW4(t)) );
}
float HygxBorder32_BC(float t, float y0) {
    return float( dFloat(1.) *
    (-8*(-36 + 66*POW2(B) + 338*C - 160*POW2(C) - B*(61 + 196*C))*T8 + 1024*(3*POW2(B) - 2*(-2 + C)*C - B*(4 + C))*T7*y0 - 224*(-24 + 14*B + 3*POW2(B) + 60*C - 34*B*C - 24*POW2(C))*T6*Y2 + 1792*(3*POW2(B) + 2*(-2 + C)*C + B*(-4 + 5*C))*T5*Y3 + 560*(12 + 6*POW2(B) - 22*C + 8*POW2(C) + B*(-17 + 16*C))*T4*Y4 + 448*(3*POW2(B) + 6*(-2 + C)*C + B*(-4 + 11*C))*T3*Y5 + 112*(3*POW2(B) + 8*(-2 + C)*C + 2*B*(-2 + 7*C))*T2*Y6 + 16*(3*POW2(B) + 10*(-2 + C)*C + B*(-4 + 17*C))*t*Y7 + (3*POW2(B) + 12*(-2 + C)*C + 4*B*(-1 + 5*C))*Y8)/(6720.*POW4(t)) );
}
float HygxBorder01_BC(float t, float y0) {
    return float( dFloat(1.) *
    (POW6(1 - 2*t + y0)*(2*C*(-16*C*(3 + t + 3*y0) + 3*(9 + 4*T2 + 6*y0 + 4*t*(2 + y0) - 3*Y2)) + 2*POW2(B)*(-5 + 4*T2 - 4*t*(-2 + y0) - 4*y0 + Y2) - B*(4*C*(19 + 2*t + 4*T2 + 16*y0 + 4*t*y0 - 3*Y2) + 3*(-3 + 4*t + 4*T2 - 2*y0 - 4*t*y0 + Y2))))/(10080.*POW4(t)) );
}
float HygxBorder11_BC(float t, float y0) {
    return float( dFloat(1.) *
    -(32*POW2(C)*(92*T7 - 168*T6*(1 + y0) + 84*T5*POW2(1 + y0) - 7*t*POW6(1 + y0) + 3*POW7(1 + y0)) + 36*POW6(1 - t + y0)*(3 + 3*T2 - 2*t*(-4 + y0) + 2*y0 - Y2) - 2*POW2(B)*(216*T8 + 9*(-5 + y0)*POW7(1 + y0) - 8*t*POW6(1 + y0)*(-17 + 4*y0) + 28*T3*POW4(1 + y0)*(-11 + 4*y0) - 140*T5*POW2(1 + y0)*(-5 + 4*y0) - 188*T7*(1 + 4*y0) + 504*T6*(-1 + y0 + 2*Y2)) - 6*C*(288*T8 - 224*T5*(-5 + y0)*POW2(1 + y0) - 1120*T4*POW3(1 + y0) + 560*T3*POW4(1 + y0) + 4*t*POW6(1 + y0)*(-33 + 2*y0) - POW7(1 + y0)*(-41 + 3*y0) - 32*T7*(9 + 23*y0) + 224*T6*(-2 + y0 + 3*Y2)) + B*(4*C*(288*T8 + 672*T6*POW2(1 + y0) + 280*T3*POW4(1 + y0) - 3*(-17 + y0)*POW7(1 + y0) - 112*T5*POW2(1 + y0)*(5 + 2*y0) + 2*t*POW6(1 + y0)*(-73 + 4*y0) - 16*T7*(35 + 46*y0)) + 3*(192*T8 + 112*T5*(-5 + y0)*POW2(1 + y0) - 560*T4*(-2 + y0)*POW3(1 + y0) + 112*T3*POW4(1 + y0)*(-7 + 3*y0) - 8*t*POW6(1 + y0)*(-27 + 8*y0) + POW7(1 + y0)*(-67 + 17*y0) - 16*T7*(21 + 37*y0) + 112*T6*(2 + 7*y0 + 5*Y2))))/(10080.*POW4(t)) );
}
float HygxBorder21_BC(float t, float y0) {
    return float( dFloat(1.) *
    (-32*POW2(C)*(92*T7 - 168*T6*(1 + y0) + 84*T5*POW2(1 + y0) - 7*t*POW6(1 + y0) - 3*POW7(1 + y0)) - 36*(3*T8 + 56*T6*y0*(1 + y0) + 70*T4*(-1 + y0)*POW3(1 + y0) + (-3 + y0)*POW7(1 + y0) + 2*t*POW6(1 + y0)*(-5 + 2*y0) - 14*T3*POW4(1 + y0)*(-3 + 2*y0) - 42*T5*POW2(1 + y0)*(-1 + 2*y0) - 10*T7*(1 + 2*y0)) + 2*POW2(B)*(216*T8 - 9*(-5 + y0)*POW7(1 + y0) - 8*t*POW6(1 + y0)*(-17 + 4*y0) + 28*T3*POW4(1 + y0)*(-11 + 4*y0) - 140*T5*POW2(1 + y0)*(-5 + 4*y0) - 188*T7*(1 + 4*y0) + 504*T6*(-1 + y0 + 2*Y2)) + 6*C*(288*T8 - 224*T5*(-5 + y0)*POW2(1 + y0) - 1120*T4*POW3(1 + y0) + 560*T3*POW4(1 + y0) + 4*t*POW6(1 + y0)*(-33 + 2*y0) + POW7(1 + y0)*(-41 + 3*y0) - 32*T7*(9 + 23*y0) + 224*T6*(-2 + y0 + 3*Y2)) + B*(-4*C*(288*T8 + 672*T6*POW2(1 + y0) + 280*T3*POW4(1 + y0) + 3*(-17 + y0)*POW7(1 + y0) - 112*T5*POW2(1 + y0)*(5 + 2*y0) + 2*t*POW6(1 + y0)*(-73 + 4*y0) - 16*T7*(35 + 46*y0)) + 3*(-192*T8 - 112*T5*(-5 + y0)*POW2(1 + y0) + 560*T4*(-2 + y0)*POW3(1 + y0) - 112*T3*POW4(1 + y0)*(-7 + 3*y0) + 8*t*POW6(1 + y0)*(-27 + 8*y0) + POW7(1 + y0)*(-67 + 17*y0) + 16*T7*(21 + 37*y0) - 112*T6*(2 + 7*y0 + 5*Y2))))/(10080.*POW4(t)) );
}
float HygxBorder31_BC(float t, float y0) {
    return float( dFloat(1.) *
    (-72*T4*(3*T4 + 56*T2*y0*(1 + y0) + 70*(-1 + y0)*POW3(1 + y0)) - 32*POW2(C)*(64*T7 - 336*T6*(1 + y0) - 336*T5*POW2(1 + y0) - 560*T4*POW3(1 + y0) - 420*T3*POW4(1 + y0) - 168*T2*POW5(1 + y0) - 35*t*POW6(1 + y0) - 3*POW7(1 + y0)) + 2*POW2(B)*(176*T8 - 1120*T4*(-2 + y0)*POW3(1 + y0) - (-5 + y0)*POW7(1 + y0) - 56*T2*POW5(1 + y0)*(-7 + 2*y0) - 4*t*POW6(1 + y0)*(-17 + 4*y0) - 112*T3*POW4(1 + y0)*(-11 + 4*y0) - 448*T5*POW2(1 + y0)*(-5 + 4*y0) - 256*T7*(1 + 4*y0) + 112*T6*(-1 + y0 + 2*Y2)) + 6*C*(320*T8 + 1120*T4*(-3 + y0)*POW3(1 + y0) + 224*T2*(-2 + y0)*POW5(1 + y0) + 3*(-3 + y0)*POW7(1 + y0) + 20*t*POW6(1 + y0)*(-5 + 2*y0) + 336*T3*POW4(1 + y0)*(-3 + 2*y0) + 448*T5*POW2(1 + y0)*(-1 + 2*y0) - 256*T7*(1 + 2*y0) + 448*T6*(-2 + y0 + 3*Y2)) + B*(3*(-128*T8 + 112*T2*(-2 + y0)*POW5(1 + y0) + (-3 + y0)*POW7(1 + y0) + 8*t*POW6(1 + y0)*(-5 + 2*y0) + 1120*T4*POW3(1 + y0)*(-3 + 2*y0) + 224*T3*POW4(1 + y0)*(-3 + 2*y0) + 896*T5*POW2(1 + y0)*(-1 + 2*y0) + 512*T7*(1 + 2*y0) + 224*T6*(-2 + y0 + 3*Y2)) - 4*C*(320*T8 + 1120*T4*(-4 + y0)*POW3(1 + y0) + 224*T2*(-5 + y0)*POW5(1 + y0) + POW7(1 + y0)*(-19 + 3*y0) + 224*T5*POW2(1 + y0)*(-17 + 4*y0) - 128*T7*(5 + 4*y0) + 56*T3*POW4(1 + y0)*(-53 + 12*y0) + 2*t*POW6(1 + y0)*(-113 + 20*y0) + 448*T6*(-1 + 2*y0 + 3*Y2))))/(10080.*POW4(t)) );
}
float HygxBorder00_BC(float t, float y0) {
    return float( dFloat(1.) *
    (POW6(2 - 2*t + y0)*(POW2(B)*POW2(2 - 2*t + y0) + 4*B*C*(4 + 4*T2 + 8*y0 - 8*t*(1 + y0) + 3*Y2) - 4*POW2(C)*(12*T2 + 4*t*(8 + 3*y0) - 3*(-4 + 4*y0 + 3*Y2))))/(40320.*POW4(t)) );
}
float HygxBorder10_BC(float t, float y0) {
    return float( dFloat(1.) *
    (POW2(B)*(216*T8 - 752*T7*(2 + y0) + 1008*T6*POW2(2 + y0) - 560*T5*POW3(2 + y0) + 112*T3*POW5(2 + y0) - 32*t*POW7(2 + y0) + 9*POW8(2 + y0)) - 4*C*(-6*POW6(2 - t + y0)*(4 + 9*T2 + t*(8 - 6*y0) - 4*y0 - 3*Y2) + C*(864*T8 - 672*T5*(1 + y0)*POW2(2 + y0) - 3*POW7(2 + y0)*(-2 + 3*y0) + 8*t*POW6(2 + y0)*(-1 + 3*y0) - 736*T7*(5 + 3*y0) + 672*T6*(8 + 10*y0 + 3*Y2))) + 4*B*(3*POW7(-2 + t - y0)*(2 + 3*t + y0) + C*(180*T8 + 56*T3*POW4(2 + y0)*(1 + 3*y0) + 3*POW7(2 + y0)*(-2 + 5*y0) - 4*t*POW6(2 + y0)*(-2 + 13*y0) - 56*T5*POW2(2 + y0)*(11 + 13*y0) - 8*T7*(143 + 95*y0) + 168*T6*(16 + 22*y0 + 7*Y2))))/(40320.*POW4(t)) );
}
float HygxBorder20_BC(float t, float y0) {
    return float( dFloat(1.) *
    (POW2(B)*(216*T8 - 752*T7*(2 + y0) + 1008*T6*POW2(2 + y0) - 560*T5*POW3(2 + y0) + 112*T3*POW5(2 + y0) - 32*t*POW7(2 + y0) - 9*POW8(2 + y0)) - 4*C*(-6*(9*T8 - 252*T5*(1 + y0)*POW2(2 + y0) + POW7(2 + y0)*(-2 + 3*y0) + 4*t*POW6(2 + y0)*(-1 + 3*y0) - 28*T3*POW4(2 + y0)*(1 + 3*y0) + 70*T4*POW3(2 + y0)*(2 + 3*y0) - 20*T7*(5 + 3*y0) + 56*T6*(8 + 10*y0 + 3*Y2)) + C*(864*T8 - 672*T5*(1 + y0)*POW2(2 + y0) + 3*POW7(2 + y0)*(-2 + 3*y0) + 8*t*POW6(2 + y0)*(-1 + 3*y0) - 736*T7*(5 + 3*y0) + 672*T6*(8 + 10*y0 + 3*Y2))) + 4*B*(3*(3*T8 - 20*T7*(2 + y0) + 56*T6*POW2(2 + y0) - 84*T5*POW3(2 + y0) + 70*T4*POW4(2 + y0) - 28*T3*POW5(2 + y0) + 4*t*POW7(2 + y0) + POW8(2 + y0)) + C*(180*T8 + 56*T3*POW4(2 + y0)*(1 + 3*y0) - 3*POW7(2 + y0)*(-2 + 5*y0) - 4*t*POW6(2 + y0)*(-2 + 13*y0) - 56*T5*POW2(2 + y0)*(11 + 13*y0) - 8*T7*(143 + 95*y0) + 168*T6*(16 + 22*y0 + 7*Y2))))/(40320.*POW4(t)) );
}
float HygxBorder30_BC(float t, float y0) {
    return float( dFloat(1.) *
    (POW2(B)*(176*T8 - 1024*T7*(2 + y0) + 224*T6*POW2(2 + y0) - 1792*T5*POW3(2 + y0) - 1120*T4*POW4(2 + y0) - 448*T3*POW5(2 + y0) - 112*T2*POW6(2 + y0) - 16*t*POW7(2 + y0) - POW8(2 + y0)) - 4*C*(-12*T4*(9*T4 + 70*POW3(2 + y0)*(2 + 3*y0) + 56*T2*(8 + 10*y0 + 3*Y2)) + C*(960*T8 + 2688*T5*(1 + y0)*POW2(2 + y0) + 672*T2*y0*POW5(2 + y0) + 3*POW7(2 + y0)*(-2 + 3*y0) + 40*t*POW6(2 + y0)*(-1 + 3*y0) + 672*T3*POW4(2 + y0)*(1 + 3*y0) + 1120*T4*POW3(2 + y0)*(2 + 3*y0) - 512*T7*(5 + 3*y0) + 1344*T6*(8 + 10*y0 + 3*Y2))) + 4*B*(6*T4*(3*T4 + 56*T2*POW2(2 + y0) + 70*POW4(2 + y0)) + C*(104*T8 - 2240*T4*(1 + y0)*POW3(2 + y0) - POW7(2 + y0)*(2 + 3*y0) - 56*T2*POW5(2 + y0)*(4 + 5*y0) - 256*T7*(8 + 5*y0) - 448*T5*POW2(2 + y0)*(8 + 7*y0) - 112*T3*POW4(2 + y0)*(8 + 9*y0) - 4*t*POW6(2 + y0)*(8 + 11*y0) - 112*T6*(16 + 14*y0 + 3*Y2))))/(40320.*POW4(t)) );
}


#pragma endregion

#pragma region CUBICBC Hygx_cubicBC
float Hygx_cubicBC(float xIn, float t, float y0)
{
    float x = min(xIn, 1.9999); // clip x against right border of filter footprint
                                // such that value at x==2 is being repeated for all x>2
                                // TODO: change 1.9999 into 2.0
    float gx = t * x + y0;  // y=g(x) defines the (diagonal) line where integration is along

    if (x <= -2.0 + 0.0001) return 0; // to the west of all cells, obtaining weight = 0
    // Next "early exit" can safely be omitted.
    if (t >= 0 && gx < -2) return 0; // to the south of all cells, only with positive tangent, obtains weight = 0

    // first, evaluate base integral Hygx-cells for the 16 cell area's
    // ---------------------------------------------------------------
    float wBase = 0; // weight of cell integral (with constants for vertical line x == -2,-1,0,1,2)

    // globals; made powers of x and t globals to reduce code redundancy for now.
    // Compute these powers here i.s.o. in each of the cell functions
    X2 = x*x; X3 = X2*x; X4 = X3*x; X5 = X4*x; X6 = X5*x; X7 = X6*x; X8 = X7*x;
    T2 = t*t; T3 = T2*t; T4 = T3*t; T5 = T4*t; T6 = T5*t; T7 = T6*t; T8 = T7*t;
    Y2 = y0*y0; Y3 = Y2*y0; Y4 = Y3*y0; Y5 = Y4*y0; Y6 = Y5*y0; Y7 = Y6*y0; Y8 = Y7*y0;
	

    // NOTE: ONLY THE BASE FUNCTIONS WITHIN THE AA-FILTER FOOTPRINT NEED TO BE IMPLEMENTED
    // VERTICAL CLIPPING IN WtEdgeAB ensures functions outside are not required.
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (gx >= +1) { wBase = i2cell03_BC(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell02_BC(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell01_BC(x, t, y0); }
        else               { wBase = i2cell00_BC(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (gx >= +1) { wBase = i2cell13_BC(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell12_BC(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell11_BC(x, t, y0); }
        else               { wBase = i2cell10_BC(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (gx >= +1) { wBase = i2cell23_BC(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell22_BC(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell21_BC(x, t, y0); }
        else               { wBase = i2cell20_BC(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (gx >= +1) { wBase = i2cell33_BC(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell32_BC(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell31_BC(x, t, y0); }
        else               { wBase = i2cell30_BC(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }

    // second, add diagonal "row"-constants ALLONG TANGENT LINE for (overlapping) area's
    // ---------------------------------------------------------------------------------

    // Compute integral constants at horizontal cell piecewise discontinuities at HygxBorder[xy]
    // Where [xy] indicate the bottom border of cell[xy].
    // 2D overlapping area's of constants are defined by 
    // - horizontal range   where x is restricted to -2 < x < +2
    // - vertical range     where gx is restricted
    // - diagonal range     where y0 is restricted

    float wConst = 0;
    int st = SIGN(t);

    // HygxBorder*4: Only needed for negative tangent; below horizontal line: g(x) = +2
    if (t < 0 && gx <= 2.0001)
    {
        // Border04 for negative t:  y0 <= 2 + t  &&  y0 > 2 + 2t (since st=-1, conditions can be simplified)
        if      ( ((2 +   t - y0)*st <= 0)  &&  ((2 + 2*t - y0)*st > 0) ) wConst += HygxBorder04_BC(t, y0);
        else if ( ((2       - y0)*st <= 0)  &&  ((2 +   t - y0)*st > 0) ) wConst += HygxBorder14_BC(t, y0);
        else if ( ((2 -   t - y0)*st <= 0)  &&  ((2       - y0)*st > 0) ) wConst += HygxBorder24_BC(t, y0);
        else if (/*(2 - 2*t - y0)*st <= 0 */    ((2 -   t - y0)*st > 0) ) wConst += HygxBorder34_BC(t, y0);
    }
    // HygxBorder*3: For positive and negative tangent; above respectively below horizontal line: g(x) = +1
    if ( (t >= 0 && gx >= 1) || (t < 0 && gx < 1) )
    {
        // Border03 positive t: y0 >= 1 + t  &&  y0 < 1 + 2t, negative t: y0 <= 1 + t  &&  y0 > 1 + 2t
        if      ( ((1 +   t - y0)*st <= 0)  &&  ((1 + 2*t - y0)*st > 0) ) wConst += HygxBorder03_BC(t, y0);
        else if ( ((1       - y0)*st <= 0)  &&  ((1 +   t - y0)*st > 0) ) wConst += HygxBorder13_BC(t, y0);
        else if ( ((1 -   t - y0)*st <= 0)  &&  ((1       - y0)*st > 0) ) wConst += HygxBorder23_BC(t, y0);
        else if (/*(1 - 2*t - y0)*st <= 0 */    ((1 -   t - y0)*st > 0) ) wConst += HygxBorder33_BC(t, y0);
    }
    // HygxBorder*2: For positive and negative tangent; above respectively below horizontal line: g(x) = 0
    if ( (t >= 0 && gx >= 0) || (t < 0 && gx < 0) )
    {
        // Border02 positive t: y0 >= 0 + t  &&  y0 < 0 + 2t, negative t: y0 <= 0 + t  &&  y0 > 0 + 2t
        if      ( ((0 +   t - y0)*st <= 0)  &&  ((0 + 2*t - y0)*st > 0) ) wConst += HygxBorder02_BC(t, y0);
        else if ( ((0       - y0)*st <= 0)  &&  ((0 +   t - y0)*st > 0) ) wConst += HygxBorder12_BC(t, y0);
        else if ( ((0 -   t - y0)*st <= 0)  &&  ((0       - y0)*st > 0) ) wConst += HygxBorder22_BC(t, y0);
        else if (/*(0 - 2*t - y0)*st <= 0 */    ((0 -   t - y0)*st > 0) ) wConst += HygxBorder32_BC(t, y0);
    }
    // HygxBorder*1: For positive and negative tangent; above respectively below horizontal line: g(x) = -1
    if ( (t >= 0 && gx >= -1) || (t < 0 && gx < -1) )
    {
        // Border01 positive t: y0 >= -1 + t  &&  y0 < -1 + 2t, negative t: y0 <= -1 + t  &&  y0 > -1 + 2t
        if      ( ((-1 +   t - y0)*st <= 0)  &&  ((-1 + 2*t - y0)*st > 0) ) wConst += HygxBorder01_BC(t, y0);
        else if ( ((-1       - y0)*st <= 0)  &&  ((-1 +   t - y0)*st > 0) ) wConst += HygxBorder11_BC(t, y0);
        else if ( ((-1 -   t - y0)*st <= 0)  &&  ((-1       - y0)*st > 0) ) wConst += HygxBorder21_BC(t, y0);
        else if (/*(-1 - 2*t - y0)*st <= 0 */    ((-1 -   t - y0)*st > 0) ) wConst += HygxBorder31_BC(t, y0);
    }
    // HygxBorder*0: Only needed for positive tangent; above horizontal line: g(x) = -2
    if ( t > 0 && gx >= -2 )
    {
        // Border00 positive t: y0 >= -2 + t  &&  y0 < -2 + 2t (since st=1, conditions can be simplified)
        if      ( ((-2 +   t - y0)*st <= 0)  &&  ((-2 + 2*t - y0)*st > 0) ) wConst += HygxBorder00_BC(t, y0);
        else if ( ((-2       - y0)*st <= 0)  &&  ((-2 +   t - y0)*st > 0) ) wConst += HygxBorder10_BC(t, y0);
        else if ( ((-2 -   t - y0)*st <= 0)  &&  ((-2       - y0)*st > 0) ) wConst += HygxBorder20_BC(t, y0);
        else if (/*(-2 - 2*t - y0)*st <= 0 */    ((-2 -   t - y0)*st > 0) ) wConst += HygxBorder30_BC(t, y0);
    }

    float weight = wBase - wConst * st;
    return weight;
}
#pragma endregion

// ============================================================================

#pragma region CubicStrong Hyx polynomials
// When tangent=0, i.e. exact horizontal edge. Robust against xa==xb

float HyxCell00_BC(float x, float y) {
    return
    (POW3(2 + x)*(B*(2 + x) + 2*C*(2 + 3*x))*POW3(2 + y)*(B*(2 + y) + 2*C*(2 + 3*y)))/576.;
}
float HyxCell10_BC(float x, float y) {
    return
    ((12 - 8*(-3 + B)*x + 8*(-3 + 2*B + C)*X3 + 3*(-4 + 3*B + 2*C)*X4)*POW3(2 + y)*(B*(2 + y) + 2*C*(2 + 3*y)))/576.;
}
float HyxCell20_BC(float x, float y) {
    return
    -((-12 + 8*(-3 + B)*x - 8*(-3 + 2*B + C)*X3 + 3*(-4 + 3*B + 2*C)*X4)*POW3(2 + y)*(B*(2 + y) + 2*C*(2 + 3*y)))/576.;
}
float HyxCell30_BC(float x, float y) {
    return
    -((-24 + B*POW4(-2 + x) + 2*C*POW3(-2 + x)*(-2 + 3*x))*POW3(2 + y)*(B*(2 + y) + 2*C*(2 + 3*y)))/576.;
}
float HyxCell01_BC(float x, float y) {
    return
    (POW3(2 + x)*(B*(2 + x) + 2*C*(2 + 3*x))*(12 - 8*(-3 + B)*y + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4))/576.;
}
float HyxCell11_BC(float x, float y) {
    return
    (12*(12 - 8*(-3 + B)*y + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) - 8*(-3 + B)*x*(12 - 8*(-3 + B)*y + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) + 3*X4*(48*(-1 + y)*POW3(1 + y) + 4*POW2(C)*(4 + 3*y)*Y3 + 3*POW2(B)*y*(-8 + 16*Y2 + 9*Y3) - 8*C*(-3 - 6*y + 10*Y3 + 6*Y4) + 4*B*(9 + (26 - 4*C)*y + 2*(-17 + 7*C)*Y3 + 9*(-2 + C)*Y4)) + 8*X3*(36*(-1 + y)*POW3(1 + y) + 2*POW2(C)*(4 + 3*y)*Y3 + 2*POW2(B)*y*(-8 + 16*Y2 + 9*Y3) - 6*C*(-2 - 4*y + 8*Y3 + 5*Y4) + B*(24 - 8*(-9 + C)*y + 32*(-3 + C)*Y3 + 3*(-17 + 7*C)*Y4)))/576.;
}
float HyxCell21_BC(float x, float y) {
    return
    (12*(12 - 8*(-3 + B)*y + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) - 8*(-3 + B)*x*(12 - 8*(-3 + B)*y + 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) - 3*X4*(48*(-1 + y)*POW3(1 + y) + 4*POW2(C)*(4 + 3*y)*Y3 + 3*POW2(B)*y*(-8 + 16*Y2 + 9*Y3) - 8*C*(-3 - 6*y + 10*Y3 + 6*Y4) + 4*B*(9 + (26 - 4*C)*y + 2*(-17 + 7*C)*Y3 + 9*(-2 + C)*Y4)) + 8*X3*(36*(-1 + y)*POW3(1 + y) + 2*POW2(C)*(4 + 3*y)*Y3 + 2*POW2(B)*y*(-8 + 16*Y2 + 9*Y3) - 6*C*(-2 - 4*y + 8*Y3 + 5*Y4) + B*(24 - 8*(-9 + C)*y + 32*(-3 + C)*Y3 + 3*(-17 + 7*C)*Y4)))/576.;
}
float HyxCell31_BC(float x, float y) {
    return
    (-(POW2(B)*POW4(-2 + x)*y*(-8 + 16*Y2 + 9*Y3)) - 4*(72*(-1 + y)*POW3(1 + y) + POW2(C)*POW3(-2 + x)*(-2 + 3*x)*(4 + 3*y)*Y3 - 6*C*(-16 - 32*y - 48*x*(-1 + y)*POW3(1 + y) + 48*X2*(-1 + y)*POW3(1 + y) - 20*X3*(-1 + y)*POW3(1 + y) + 3*X4*(-1 + y)*POW3(1 + y) + 40*Y3 + 22*Y4)) - 4*B*(X4*(3 + (6 - 12*C)*y + (-6 + 26*C)*Y3 + 3*(-1 + 5*C)*Y4) + 12*X2*(6 - 4*(-3 + 4*C)*y + 12*(-1 + 3*C)*Y3 + 3*(-2 + 7*C)*Y4) - 8*x*(12 - 24*(-1 + C)*y + 8*(-3 + 7*C)*Y3 + 3*(-4 + 11*C)*Y4) - 2*X3*(12 - 8*(-3 + 5*C)*y + 8*(-3 + 11*C)*Y3 + 3*(-4 + 17*C)*Y4) + 2*(24 - 8*(-9 + 4*C)*y + 16*(-6 + 5*C)*Y3 + (-51 + 48*C)*Y4)))/576.;
}
float HyxCell02_BC(float x, float y) {
    return
    -(POW3(2 + x)*(B*(2 + x) + 2*C*(2 + 3*x))*(-12 + 8*(-3 + B)*y - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4))/576.;
}
float HyxCell12_BC(float x, float y) {
    return
    (-12*(-12 + 8*(-3 + B)*y - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) + 8*(-3 + B)*x*(-12 + 8*(-3 + B)*y - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) - 3*X4*(4*POW2(C)*(-4 + 3*y)*Y3 + 3*POW2(B)*y*(8 - 16*Y2 + 9*Y3) + 48*(1 + 2*y - 2*Y3 + Y4) - 8*C*(3 + 6*y - 10*Y3 + 6*Y4) + 4*B*(-9 + (-26 + 4*C)*y + (34 - 14*C)*Y3 + 9*(-2 + C)*Y4)) - 8*X3*(2*POW2(C)*(-4 + 3*y)*Y3 + 2*POW2(B)*y*(8 - 16*Y2 + 9*Y3) + 36*(1 + 2*y - 2*Y3 + Y4) - 6*C*(2 + 4*y - 8*Y3 + 5*Y4) + B*(-24 + 8*(-9 + C)*y - 32*(-3 + C)*Y3 + 3*(-17 + 7*C)*Y4)))/576.;
}
float HyxCell22_BC(float x, float y) {
    return
    (-12*(-12 + 8*(-3 + B)*y - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) + 8*(-3 + B)*x*(-12 + 8*(-3 + B)*y - 8*(-3 + 2*B + C)*Y3 + 3*(-4 + 3*B + 2*C)*Y4) + 3*X4*(4*POW2(C)*(-4 + 3*y)*Y3 + 3*POW2(B)*y*(8 - 16*Y2 + 9*Y3) + 48*(1 + 2*y - 2*Y3 + Y4) - 8*C*(3 + 6*y - 10*Y3 + 6*Y4) + 4*B*(-9 + (-26 + 4*C)*y + (34 - 14*C)*Y3 + 9*(-2 + C)*Y4)) - 8*X3*(2*POW2(C)*(-4 + 3*y)*Y3 + 2*POW2(B)*y*(8 - 16*Y2 + 9*Y3) + 36*(1 + 2*y - 2*Y3 + Y4) - 6*C*(2 + 4*y - 8*Y3 + 5*Y4) + B*(-24 + 8*(-9 + C)*y - 32*(-3 + C)*Y3 + 3*(-17 + 7*C)*Y4)))/576.;
}
float HyxCell32_BC(float x, float y) {
    return
    (POW2(B)*POW4(-2 + x)*y*(8 - 16*Y2 + 9*Y3) + 4*B*(X4*(-3 + 6*(-1 + 2*C)*y + (6 - 26*C)*Y3 + 3*(-1 + 5*C)*Y4) + 12*X2*(-6 + 4*(-3 + 4*C)*y + (12 - 36*C)*Y3 + 3*(-2 + 7*C)*Y4) - 8*x*(-12 + 24*(-1 + C)*y - 8*(-3 + 7*C)*Y3 + 3*(-4 + 11*C)*Y4) + X3*(24 + (48 - 80*C)*y + 16*(-3 + 11*C)*Y3 - 6*(-4 + 17*C)*Y4) + 2*(-24 + 8*(-9 + 4*C)*y + (96 - 80*C)*Y3 + (-51 + 48*C)*Y4)) + 4*(POW2(C)*POW3(-2 + x)*(-2 + 3*x)*(-4 + 3*y)*Y3 + 72*(1 + 2*y - 2*Y3 + Y4) - 6*C*(16 + 32*y - 40*Y3 + 22*Y4 - 48*x*(1 + 2*y - 2*Y3 + Y4) + 48*X2*(1 + 2*y - 2*Y3 + Y4) - 20*X3*(1 + 2*y - 2*Y3 + Y4) + 3*X4*(1 + 2*y - 2*Y3 + Y4))))/576.;
}
float HyxCell03_BC(float x, float y) {
    return
    -(POW3(2 + x)*(B*(2 + x) + 2*C*(2 + 3*x))*(-24 + B*POW4(-2 + y) + 2*C*POW3(-2 + y)*(-2 + 3*y)))/576.;
}
float HyxCell13_BC(float x, float y) {
    return
    (-(POW2(B)*x*(-8 + 16*X2 + 9*X3)*POW4(-2 + y)) - 4*B*(3*POW4(-2 + y) - 4*C*x*POW3(-2 + y)*(-2 + 3*y) + 3*X4*(-34 + 32*y + C*POW3(-2 + y)*(-4 + 5*y) - 24*Y2 + 8*Y3 - Y4) + 6*x*(24 - 32*y + 24*Y2 - 8*Y3 + Y4) + 2*X3*(C*POW3(-2 + y)*(-10 + 13*y) - 3*(32 - 32*y + 24*Y2 - 8*Y3 + Y4))) - 4*(72*(-1 + x)*POW3(1 + x) + POW2(C)*(4 + 3*x)*X3*POW3(-2 + y)*(-2 + 3*y) - 6*C*(-(POW3(-2 + y)*(-2 + 3*y)) - 2*x*POW3(-2 + y)*(-2 + 3*y) + X4*(22 - 48*y + 48*Y2 - 20*Y3 + 3*Y4) + X3*(40 - 96*y + 96*Y2 - 40*Y3 + 6*Y4))))/576.;
}
float HyxCell23_BC(float x, float y) {
    return
    (288 - 12*B*POW4(-2 + y) - 24*C*POW3(-2 + y)*(-2 + 3*y) + 8*(-3 + B)*x*(-24 + B*POW4(-2 + y) + 2*C*POW3(-2 + y)*(-2 + 3*y)) + 3*X4*(3*POW2(B)*POW4(-2 + y) + 4*(24 + POW2(C)*POW3(-2 + y)*(-2 + 3*y) + C*(-44 + 96*y - 96*Y2 + 40*Y3 - 6*Y4)) + 4*B*(-34 + 32*y + C*POW3(-2 + y)*(-4 + 5*y) - 24*Y2 + 8*Y3 - Y4)) + 8*X3*(-72 - 2*POW2(B)*POW4(-2 + y) - 2*POW2(C)*POW3(-2 + y)*(-2 + 3*y) - B*C*POW3(-2 + y)*(-10 + 13*y) + 3*B*(32 - 32*y + 24*Y2 - 8*Y3 + Y4) + 6*C*(20 - 48*y + 48*Y2 - 20*Y3 + 3*Y4)))/576.;
}
float HyxCell33_BC(float x, float y) {
    return
    (576 + POW2(B)*POW4(-2 + x)*POW4(-2 + y) + 4*POW2(C)*POW3(-2 + x)*(-2 + 3*x)*POW3(-2 + y)*(-2 + 3*y) + 4*B*C*POW3(-2 + x)*POW3(-2 + y)*(4 - 4*y + x*(-4 + 3*y)) - 24*B*(32 - 32*x + 24*X2 - 8*X3 + X4 - 32*y + 24*Y2 - 8*Y3 + Y4) - 48*C*(32 - 48*x + 48*X2 - 20*X3 + 3*X4 - 48*y + 48*Y2 - 20*Y3 + 3*Y4))/576.;
}

float Hyx_cubicBC(float x, float y)
{
	// globals; gives more readable cell functions and reduces redundancy
	X2 = x*x; X3 = X2*x; X4 = X3*x;
    Y2 = y*y; Y3 = Y2*y; Y4 = Y3*y;
    float w = 0;
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (y >= +1) w = HyxCell03_BC(x, y);
        else if (y >=  0) w = HyxCell02_BC(x, y);
        else if (y >= -1) w = HyxCell01_BC(x, y);
        else              w = HyxCell00_BC(x, y);
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (y >= +1) w = HyxCell13_BC(x, y);
        else if (y >=  0) w = HyxCell12_BC(x, y);
        else if (y >= -1) w = HyxCell11_BC(x, y);
        else              w = HyxCell10_BC(x, y);
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (y >= +1) w = HyxCell23_BC(x, y);
        else if (y >=  0) w = HyxCell22_BC(x, y);
        else if (y >= -1) w = HyxCell21_BC(x, y);
        else              w = HyxCell20_BC(x, y);
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (y >= +1) w = HyxCell33_BC(x, y);
        else if (y >=  0) w = HyxCell32_BC(x, y);
        else if (y >= -1) w = HyxCell31_BC(x, y);
        else              w = HyxCell30_BC(x, y);
    }
    return w;
}
#pragma endregion
