#version 330

// We use following convention of variable name prefixes:
// u_   uniform - may change per primitive, from appl to any shader
// s_   uniform sampler - associated with a texture unit having a texture map
// a_   attribute  per vertex attribute, appl to vertex shader
// v_   varying  used for interpolated values from vertex shader to fragment shader

// Matrices block filled by VSMathLib
layout (std140) uniform Matrices {
	mat4 u_projViewModelMatrix;
	mat4 u_viewModelMatrix;
    mat3 u_viewMatrix;
	mat3 u_normalMatrix;
};

uniform vec3 u_lightDir;

in vec4 position;
in vec2 texCoord;

out	vec2 v_texCoord;

void main ()
{
	v_texCoord = texCoord;
	gl_Position = u_projViewModelMatrix * position;	
}