// Hygx cubic filter function for B=0 and C=1

#version 430

#define SIGN(x)           ( int(x >= 0) - int(x < 0) )  // GLSL sign(0) gives 0 i.s.o 1

// #defines and globals
#define POW2(x)	((x)*(x))
#define POW3(x)	((x)*(x)*(x))
#define POW4(x)	((x)*(x)*(x)*(x))
#define POW5(x)	((x)*(x)*(x)*(x)*(x))
#define POW6(x)	((x)*(x)*(x)*(x)*(x)*(x))
#define POW7(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x))
#define POW8(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x)*(x))

float X2, X3, X4, X5, X6, X7, X8;
float T2, T3, T4, T5, T6, T7, T8;
float Y2, Y3, Y4, Y5, Y6, Y7, Y8;

#pragma region Base integral Cell expressions
// generated in cubicMitchell-mm113_4x4cellsAproach.nb

float i2cell00_B0C1(float x, float t, float y0) {
    return
    (POW3(2 + x)*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 168*t*(-2 + 3*x + 12*X2)*(1 + y0)*POW2(2 + y0) + 70*(2 + 3*x)*POW3(2 + y0)*(2 + 3*y0) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(5 + 3*y0) + 840*T2*X3*(8 + 10*y0 + 3*Y2)))/10080.;
}
float i2cell10_B0C1(float x, float t, float y0) {
    return
    (-9*T4*(90 - 56*X5 + 80*X7 + 35*X8) - 168*t*(5 - 30*X2 + 30*X4 + 12*X5)*(1 + y0)*POW2(2 + y0) - 70*(-6 - 12*x + 8*X3 + 3*X4)*POW3(2 + y0)*(2 + 3*y0) - 8*T3*(-77 - 105*X4 + 140*X6 + 60*X7)*(5 + 3*y0) - 168*T2*(2 - 10*X3 + 12*X5 + 5*X6)*(8 + 10*y0 + 3*Y2))/10080.;
}
float i2cell20_B0C1(float x, float t, float y0) {
    return
    (9*T4*(-90 + 56*X5 - 80*X7 + 35*X8) + 168*t*(-5 + 30*X2 - 30*X4 + 12*X5)*(1 + y0)*POW2(2 + y0) + 70*(6 + 12*x - 8*X3 + 3*X4)*POW3(2 + y0)*(2 + 3*y0) + 8*T3*(77 + 105*X4 - 140*X6 + 60*X7)*(5 + 3*y0) + 168*T2*(-2 + 10*X3 - 12*X5 + 5*X6)*(8 + 10*y0 + 3*Y2))/10080.;
}
float i2cell30_B0C1(float x, float t, float y0) {
    return
    (-3*T4*(284 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) - 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*(1 + y0)*POW2(2 + y0) - 70*(4 - 48*x + 48*X2 - 20*X3 + 3*X4)*POW3(2 + y0)*(2 + 3*y0) - 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(5 + 3*y0) - 168*T2*(4 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*(8 + 10*y0 + 3*Y2))/10080.;
}
float i2cell01_B0C1(float x, float t, float y0) {
    return
    -(POW3(2 + x)*(3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(2 + 3*y0) + 840*T2*X3*y0*(4 + 3*y0) + 168*t*(-2 + 3*x + 12*X2)*(-1 + 2*Y2 + Y3) + 70*(2 + 3*x)*(-6 - 12*y0 + 8*Y3 + 3*Y4)))/10080.;
}
float i2cell11_B0C1(float x, float t, float y0) {
    return
    (9*T4*(90 - 56*X5 + 80*X7 + 35*X8) + 8*T3*(-77 - 105*X4 + 140*X6 + 60*X7)*(2 + 3*y0) + 168*T2*(2 - 10*X3 + 12*X5 + 5*X6)*y0*(4 + 3*y0) + 168*t*(5 - 30*X2 + 30*X4 + 12*X5)*(-1 + 2*Y2 + Y3) + 70*(-6 - 12*x + 8*X3 + 3*X4)*(-6 - 12*y0 + 8*Y3 + 3*Y4))/10080.;
}
float i2cell21_B0C1(float x, float t, float y0) {
    return
    (-9*T4*(-90 + 56*X5 - 80*X7 + 35*X8) - 8*T3*(77 + 105*X4 - 140*X6 + 60*X7)*(2 + 3*y0) - 168*T2*(-2 + 10*X3 - 12*X5 + 5*X6)*y0*(4 + 3*y0) - 168*t*(-5 + 30*X2 - 30*X4 + 12*X5)*(-1 + 2*Y2 + Y3) - 70*(6 + 12*x - 8*X3 + 3*X4)*(-6 - 12*y0 + 8*Y3 + 3*Y4))/10080.;
}
float i2cell31_B0C1(float x, float t, float y0) {
    return
    (3*T4*(284 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(2 + 3*y0) + 168*T2*(4 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*y0*(4 + 3*y0) + 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*(-1 + 2*Y2 + Y3) + 70*(4 - 48*x + 48*X2 - 20*X3 + 3*X4)*(-6 - 12*y0 + 8*Y3 + 3*Y4))/10080.;
}
float i2cell02_B0C1(float x, float t, float y0) {
    return
    -(POW3(2 + x)*(-3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(2 - 3*y0) + 840*T2*X3*(4 - 3*y0)*y0 + 168*t*(-2 + 3*x + 12*X2)*(-1 + y0)*(1 + y0 - Y2) - 70*(2 + 3*x)*(6 + 12*y0 - 8*Y3 + 3*Y4)))/10080.;
}
float i2cell12_B0C1(float x, float t, float y0) {
    return
    (-9*T4*(90 - 56*X5 + 80*X7 + 35*X8) - 168*T2*(2 - 10*X3 + 12*X5 + 5*X6)*y0*(-4 + 3*y0) - 8*T3*(-77 - 105*X4 + 140*X6 + 60*X7)*(-2 + 3*y0) - 168*t*(5 - 30*X2 + 30*X4 + 12*X5)*(1 - 2*Y2 + Y3) - 70*(-6 - 12*x + 8*X3 + 3*X4)*(6 + 12*y0 - 8*Y3 + 3*Y4))/10080.;
}
float i2cell22_B0C1(float x, float t, float y0) {
    return
    (9*T4*(-90 + 56*X5 - 80*X7 + 35*X8) + 168*T2*(-2 + 10*X3 - 12*X5 + 5*X6)*y0*(-4 + 3*y0) + 8*T3*(77 + 105*X4 - 140*X6 + 60*X7)*(-2 + 3*y0) + 168*t*(-5 + 30*X2 - 30*X4 + 12*X5)*(1 - 2*Y2 + Y3) + 70*(6 + 12*x - 8*X3 + 3*X4)*(6 + 12*y0 - 8*Y3 + 3*Y4))/10080.;
}
float i2cell32_B0C1(float x, float t, float y0) {
    return
    (-3*T4*(284 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) - 168*T2*(4 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*y0*(-4 + 3*y0) - 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(-2 + 3*y0) - 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*(1 - 2*Y2 + Y3) - 70*(4 - 48*x + 48*X2 - 20*X3 + 3*X4)*(6 + 12*y0 - 8*Y3 + 3*Y4))/10080.;
}
float i2cell03_B0C1(float x, float t, float y0) {
    return
    -(POW3(2 + x)*(-840*(2 + 3*x) + 3*T4*(-32 + 48*x - 48*X2 + 40*X3 - 30*X4 + 105*X5) + 168*t*(-2 + 3*x + 12*X2)*POW2(-2 + y0)*(-1 + y0) + 16*T3*(4 - 6*x + 6*X2 - 5*X3 + 30*X4)*(-5 + 3*y0) + 70*(2 + 3*x)*POW3(-2 + y0)*(-2 + 3*y0) + 840*T2*X3*(8 - 10*y0 + 3*Y2)))/10080.;
}
float i2cell13_B0C1(float x, float t, float y0) {
    return
    (9*T4*(90 - 56*X5 + 80*X7 + 35*X8) + 168*t*(5 - 30*X2 + 30*X4 + 12*X5)*POW2(-2 + y0)*(-1 + y0) + 8*T3*(-77 - 105*X4 + 140*X6 + 60*X7)*(-5 + 3*y0) + 168*T2*(2 - 10*X3 + 12*X5 + 5*X6)*(8 - 10*y0 + 3*Y2) + 70*(-6 - 12*x + 8*X3 + 3*X4)*(4 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4))/10080.;
}
float i2cell23_B0C1(float x, float t, float y0) {
    return
    (-9*T4*(-90 + 56*X5 - 80*X7 + 35*X8) - 168*t*(-5 + 30*X2 - 30*X4 + 12*X5)*POW2(-2 + y0)*(-1 + y0) - 8*T3*(77 + 105*X4 - 140*X6 + 60*X7)*(-5 + 3*y0) - 168*T2*(-2 + 10*X3 - 12*X5 + 5*X6)*(8 - 10*y0 + 3*Y2) - 70*(6 + 12*x - 8*X3 + 3*X4)*(4 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4))/10080.;
}
float i2cell33_B0C1(float x, float t, float y0) {
    return
    1 + (3*T4*(320 - 672*X5 + 1120*X6 - 600*X7 + 105*X8) + 168*t*POW3(-2 + x)*(-2 - 3*x + 12*X2)*POW2(-2 + y0)*(-1 + y0) + 16*T3*POW3(-2 + x)*(4 + 6*x + 6*X2 + 5*X3 + 30*X4)*(-5 + 3*y0) + 70*POW3(-2 + x)*(-2 + 3*x)*POW3(-2 + y0)*(-2 + 3*y0) + 168*T2*(8 - 40*X3 + 60*X4 - 30*X5 + 5*X6)*(8 - 10*y0 + 3*Y2))/10080. + (-9*T4 - 56*T2*(8 - 10*y0 + 3*Y2) - 70*(32 - 48*x + 48*X2 - 20*X3 + 3*X4 - 48*y0 + 48*Y2 - 20*Y3 + 3*Y4))/840.;
}

#pragma endregion 

#pragma region horizontal cell borders constant expressions
// generated in cubicMitchell-mm113_4x4cellsAproach.nb

float HygxBorder04_B0C1(float t, float y0) {
    return
    -(POW6(-2 - 2*t + y0)*(12 + 12*T2 + 12*y0 + 4*t*(-8 + 3*y0) - 9*Y2))/(10080.*POW4(t));
}
float HygxBorder14_B0C1(float t, float y0) {
    return
    -(810*T8 + 840*T5*POW2(-2 + y0)*(-1 + y0) - 616*T7*(-5 + 3*y0) - 420*T4*POW3(-2 + y0)*(-2 + 3*y0) + 168*T3*POW4(-2 + y0)*(-1 + 3*y0) - 16*t*POW6(-2 + y0)*(1 + 3*y0) + 3*POW7(-2 + y0)*(2 + 3*y0) + 336*T6*(8 - 10*y0 + 3*Y2))/(10080.*POW4(t));
}
float HygxBorder24_B0C1(float t, float y0) {
    return
    (-810*T8 - 840*T5*POW2(-2 + y0)*(-1 + y0) + 616*T7*(-5 + 3*y0) + 420*T4*POW3(-2 + y0)*(-2 + 3*y0) - 168*T3*POW4(-2 + y0)*(-1 + 3*y0) + 16*t*POW6(-2 + y0)*(1 + 3*y0) + 3*POW7(-2 + y0)*(2 + 3*y0) - 336*T6*(8 - 10*y0 + 3*Y2))/(10080.*POW4(t));
}
float HygxBorder34_B0C1(float t, float y0) {
    return
    -(852*T8 + 2688*T5*POW2(-2 + y0)*(-1 + y0) + 672*T2*POW5(-2 + y0)*y0 - 512*T7*(-5 + 3*y0) + 280*T4*POW3(-2 + y0)*(-2 + 3*y0) + 672*T3*POW4(-2 + y0)*(-1 + 3*y0) + 40*t*POW6(-2 + y0)*(1 + 3*y0) + 3*POW7(-2 + y0)*(2 + 3*y0) + 672*T6*(8 - 10*y0 + 3*Y2))/(10080.*POW4(t));
}
float HygxBorder03_B0C1(float t, float y0) {
    return
    (POW6(-1 - 2*t + y0)*(-21 + 12*T2 + 30*y0 + 4*t*(-2 + 3*y0) - 9*Y2))/(5040.*POW4(t));
}
float HygxBorder13_B0C1(float t, float y0) {
    return
    (810*T8 + 420*T5*POW2(-1 + y0)*(-3 + 2*y0) + 3*POW7(-1 + y0)*(-7 + 3*y0) - 420*T4*POW3(-1 + y0)*(-5 + 3*y0) - 8*t*POW6(-1 + y0)*(-13 + 6*y0) + 84*T3*POW4(-1 + y0)*(-11 + 6*y0) - 308*T7*(-7 + 6*y0) + 336*T6*(4 - 7*y0 + 3*Y2))/(5040.*POW4(t));
}
float HygxBorder23_B0C1(float t, float y0) {
    return
    (810*T8 + 420*T5*POW2(-1 + y0)*(-3 + 2*y0) - 3*POW7(-1 + y0)*(-7 + 3*y0) - 420*T4*POW3(-1 + y0)*(-5 + 3*y0) - 8*t*POW6(-1 + y0)*(-13 + 6*y0) + 84*T3*POW4(-1 + y0)*(-11 + 6*y0) - 308*T7*(-7 + 6*y0) + 336*T6*(4 - 7*y0 + 3*Y2))/(5040.*POW4(t));
}
float HygxBorder33_B0C1(float t, float y0) {
    return
    (852*T8 + 672*T2*(-2 + y0)*POW5(-1 + y0) + 1344*T5*POW2(-1 + y0)*(-3 + 2*y0) + 3*POW7(-1 + y0)*(-7 + 3*y0) + 280*T4*POW3(-1 + y0)*(-5 + 3*y0) + 20*t*POW6(-1 + y0)*(-13 + 6*y0) + 336*T3*POW4(-1 + y0)*(-11 + 6*y0) - 256*T7*(-7 + 6*y0) + 672*T6*(4 - 7*y0 + 3*Y2))/(5040.*POW4(t));
}
float HygxBorder02_B0C1(float t, float y0) {
    return
    -(POW7(2*t - y0)*(2*t + 3*y0))/(1680.*POW4(t));
}
float HygxBorder12_B0C1(float t, float y0) {
    return
    -(270*T8 - 616*T7*y0 + 336*T6*Y2 + 280*T5*Y3 - 420*T4*Y4 + 168*T3*Y5 - 16*t*Y7 + 3*Y8)/(1680.*POW4(t));
}
float HygxBorder22_B0C1(float t, float y0) {
    return
    (-270*T8 + 616*T7*y0 - 336*T6*Y2 - 280*T5*Y3 + 420*T4*Y4 - 168*T3*Y5 + 16*t*Y7 + 3*Y8)/(1680.*POW4(t));
}
float HygxBorder32_B0C1(float t, float y0) {
    return
    -(284*T8 - 512*T7*y0 + 672*T6*Y2 + 896*T5*Y3 + 280*T4*Y4 + 672*T3*Y5 + 224*T2*Y6 + 40*t*Y7 + 3*Y8)/(1680.*POW4(t));
}
float HygxBorder01_B0C1(float t, float y0) {
    return
    (POW6(1 - 2*t + y0)*(12*T2 + 4*t*(2 + 3*y0) - 3*(7 + 10*y0 + 3*Y2)))/(5040.*POW4(t));
}
float HygxBorder11_B0C1(float t, float y0) {
    return
    (810*T8 + 420*T5*POW2(1 + y0)*(3 + 2*y0) - 420*T4*POW3(1 + y0)*(5 + 3*y0) + 3*POW7(1 + y0)*(7 + 3*y0) - 308*T7*(7 + 6*y0) + 84*T3*POW4(1 + y0)*(11 + 6*y0) - 8*t*POW6(1 + y0)*(13 + 6*y0) + 336*T6*(4 + 7*y0 + 3*Y2))/(5040.*POW4(t));
}
float HygxBorder21_B0C1(float t, float y0) {
    return
    (810*T8 + 420*T5*POW2(1 + y0)*(3 + 2*y0) - 420*T4*POW3(1 + y0)*(5 + 3*y0) - 3*POW7(1 + y0)*(7 + 3*y0) - 308*T7*(7 + 6*y0) + 84*T3*POW4(1 + y0)*(11 + 6*y0) - 8*t*POW6(1 + y0)*(13 + 6*y0) + 336*T6*(4 + 7*y0 + 3*Y2))/(5040.*POW4(t));
}
float HygxBorder31_B0C1(float t, float y0) {
    return
    (852*T8 + 672*T2*POW5(1 + y0)*(2 + y0) + 1344*T5*POW2(1 + y0)*(3 + 2*y0) + 280*T4*POW3(1 + y0)*(5 + 3*y0) + 3*POW7(1 + y0)*(7 + 3*y0) - 256*T7*(7 + 6*y0) + 336*T3*POW4(1 + y0)*(11 + 6*y0) + 20*t*POW6(1 + y0)*(13 + 6*y0) + 672*T6*(4 + 7*y0 + 3*Y2))/(5040.*POW4(t));
}
float HygxBorder00_B0C1(float t, float y0) {
    return
    -(POW6(2 - 2*t + y0)*(12*T2 + 4*t*(8 + 3*y0) - 3*(-4 + 4*y0 + 3*Y2)))/(10080.*POW4(t));
}
float HygxBorder10_B0C1(float t, float y0) {
    return
    -(864*T8 - 672*T5*(1 + y0)*POW2(2 + y0) - 3*POW7(2 + y0)*(-2 + 3*y0) + 8*t*POW6(2 + y0)*(-1 + 3*y0) - 736*T7*(5 + 3*y0) - 6*POW6(2 - t + y0)*(4 + 9*T2 + t*(8 - 6*y0) - 4*y0 - 3*Y2) + 672*T6*(8 + 10*y0 + 3*Y2))/(10080.*POW4(t));
}
float HygxBorder20_B0C1(float t, float y0) {
    return
    (-810*T8 - 840*T5*(1 + y0)*POW2(2 + y0) + 3*POW7(2 + y0)*(-2 + 3*y0) + 16*t*POW6(2 + y0)*(-1 + 3*y0) - 168*T3*POW4(2 + y0)*(1 + 3*y0) + 420*T4*POW3(2 + y0)*(2 + 3*y0) + 616*T7*(5 + 3*y0) - 336*T6*(8 + 10*y0 + 3*Y2))/(10080.*POW4(t));
}
float HygxBorder30_B0C1(float t, float y0) {
    return
    -(852*T8 + 2688*T5*(1 + y0)*POW2(2 + y0) + 672*T2*y0*POW5(2 + y0) + 3*POW7(2 + y0)*(-2 + 3*y0) + 40*t*POW6(2 + y0)*(-1 + 3*y0) + 672*T3*POW4(2 + y0)*(1 + 3*y0) + 280*T4*POW3(2 + y0)*(2 + 3*y0) - 512*T7*(5 + 3*y0) + 672*T6*(8 + 10*y0 + 3*Y2))/(10080.*POW4(t));
}

#pragma endregion 

#pragma region Hygx_cubic
float Hygx_cubic_B0C1(float xIn, float t, float y0)
{
    float x = min(xIn, 1.9999);   // clip x against right border of filter footprint
                                // such that value at x==2 is being repeated for all x>2
                                // TODO: change 1.9999 into 2.0
    float gx = t * x + y0;  // y=g(x) defines the (diagonal) line where integration is along

    if (x <= -2.0 + 0.0001) return 0; // to the west of all cells, obtaining weight = 0
    // Next "early exit" can safely be omitted.
    if (t >= 0 && gx < -2) return 0; // to the south of all cells, only with positive tangent, obtains weight = 0

    // first, evaluate base integral Hygx-cells for the 16 cell area's
    // ---------------------------------------------------------------
    float wBase = 0; // weight of cell integral (with constants for vertical line x == -2,-1,0,1,2)

    // globals; gives more readable cell functions and reduces redundancy
    X2 = x*x; X3 = X2*x; X4 = X3*x; X5 = X4*x; X6 = X5*x; X7 = X6*x; X8 = X7*x;
    T2 = t*t; T3 = T2*t; T4 = T3*t; T5 = T4*t; T6 = T5*t; T7 = T6*t; T8 = T7*t;
    Y2 = y0*y0; Y3 = Y2*y0; Y4 = Y3*y0; Y5 = Y4*y0; Y6 = Y5*y0; Y7 = Y6*y0; Y8 = Y7*y0;

    // NOTE: Only the base functions within the aa-filter footprint need to be implemented
    // vertical clipping in WtEdgeAB ensures functions outside are not required.
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (gx >= +1) { wBase = i2cell03_B0C1(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell02_B0C1(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell01_B0C1(x, t, y0); }
        else               { wBase = i2cell00_B0C1(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (gx >= +1) { wBase = i2cell13_B0C1(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell12_B0C1(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell11_B0C1(x, t, y0); }
        else               { wBase = i2cell10_B0C1(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (gx >= +1) { wBase = i2cell23_B0C1(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell22_B0C1(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell21_B0C1(x, t, y0); }
        else               { wBase = i2cell20_B0C1(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (gx >= +1) { wBase = i2cell33_B0C1(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell32_B0C1(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell31_B0C1(x, t, y0); }
        else               { wBase = i2cell30_B0C1(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }

    // second, add diagonal "row"-constants ALLONG TANGENT LINE for (overlapping) area's
    // ---------------------------------------------------------------------------------

    // Compute integral constants at horizontal cell piecewise discontinuities at HygxBorder[xy]
    // Where [xy] indicate the bottom border of cell[xy].
    // 2D overlapping area's of constants are defined by 
    // - horizontal range   where x is restricted to -2 < x < +2
    // - vertical range     where gx is restricted
    // - diagonal range     where y0 is restricted

    float wConst = 0;
    int st = SIGN(t);

    // HygxBorder*4: Only needed for negative tangent; below horizontal line: g(x) = +2
    if (t < 0 && gx <= 2.0001)
    {
        // Border04 for negative t:  y0 <= 2 + t  &&  y0 > 2 + 2t (since st=-1, conditions can be simplified)
        if      ( ((2 +   t - y0)*st <= 0)  &&  ((2 + 2*t - y0)*st > 0) ) wConst += HygxBorder04_B0C1(t, y0);
        else if ( ((2       - y0)*st <= 0)  &&  ((2 +   t - y0)*st > 0) ) wConst += HygxBorder14_B0C1(t, y0);
        else if ( ((2 -   t - y0)*st <= 0)  &&  ((2       - y0)*st > 0) ) wConst += HygxBorder24_B0C1(t, y0);
        else if (/*(2 - 2*t - y0)*st <= 0 */    ((2 -   t - y0)*st > 0) ) wConst += HygxBorder34_B0C1(t, y0);
    }
    // HygxBorder*3: For positive and negative tangent; above respectively below horizontal line: g(x) = +1
    if ( (t >= 0 && gx >= 1) || (t < 0 && gx < 1) )
    {
        // Border03 positive t: y0 >= 1 + t  &&  y0 < 1 + 2t, negative t: y0 <= 1 + t  &&  y0 > 1 + 2t
        if      ( ((1 +   t - y0)*st <= 0)  &&  ((1 + 2*t - y0)*st > 0) ) wConst += HygxBorder03_B0C1(t, y0);
        else if ( ((1       - y0)*st <= 0)  &&  ((1 +   t - y0)*st > 0) ) wConst += HygxBorder13_B0C1(t, y0);
        else if ( ((1 -   t - y0)*st <= 0)  &&  ((1       - y0)*st > 0) ) wConst += HygxBorder23_B0C1(t, y0);
        else if (/*(1 - 2*t - y0)*st <= 0 */    ((1 -   t - y0)*st > 0) ) wConst += HygxBorder33_B0C1(t, y0);
    }
    // HygxBorder*2: For positive and negative tangent; above respectively below horizontal line: g(x) = 0
    if ( (t >= 0 && gx >= 0) || (t < 0 && gx < 0) )
    {
        // Border02 positive t: y0 >= 0 + t  &&  y0 < 0 + 2t, negative t: y0 <= 0 + t  &&  y0 > 0 + 2t
        if      ( ((0 +   t - y0)*st <= 0)  &&  ((0 + 2*t - y0)*st > 0) ) wConst += HygxBorder02_B0C1(t, y0);
        else if ( ((0       - y0)*st <= 0)  &&  ((0 +   t - y0)*st > 0) ) wConst += HygxBorder12_B0C1(t, y0);
        else if ( ((0 -   t - y0)*st <= 0)  &&  ((0       - y0)*st > 0) ) wConst += HygxBorder22_B0C1(t, y0);
        else if (/*(0 - 2*t - y0)*st <= 0 */    ((0 -   t - y0)*st > 0) ) wConst += HygxBorder32_B0C1(t, y0);
    }
    // HygxBorder*1: For positive and negative tangent; above respectively below horizontal line: g(x) = -1
    if ( (t >= 0 && gx >= -1) || (t < 0 && gx < -1) )
    {
        // Border01 positive t: y0 >= -1 + t  &&  y0 < -1 + 2t, negative t: y0 <= -1 + t  &&  y0 > -1 + 2t
        if      ( ((-1 +   t - y0)*st <= 0)  &&  ((-1 + 2*t - y0)*st > 0) ) wConst += HygxBorder01_B0C1(t, y0);
        else if ( ((-1       - y0)*st <= 0)  &&  ((-1 +   t - y0)*st > 0) ) wConst += HygxBorder11_B0C1(t, y0);
        else if ( ((-1 -   t - y0)*st <= 0)  &&  ((-1       - y0)*st > 0) ) wConst += HygxBorder21_B0C1(t, y0);
        else if (/*(-1 - 2*t - y0)*st <= 0 */    ((-1 -   t - y0)*st > 0) ) wConst += HygxBorder31_B0C1(t, y0);
    }
    // HygxBorder*0: Only needed for positive tangent; above horizontal line: g(x) = -2
    if ( t > 0 && gx >= -2 )
    {
        // Border00 positive t: y0 >= -2 + t  &&  y0 < -2 + 2t (since st=1, conditions can be simplified)
        if      ( ((-2 +   t - y0)*st <= 0)  &&  ((-2 + 2*t - y0)*st > 0) ) wConst += HygxBorder00_B0C1(t, y0);
        else if ( ((-2       - y0)*st <= 0)  &&  ((-2 +   t - y0)*st > 0) ) wConst += HygxBorder10_B0C1(t, y0);
        else if ( ((-2 -   t - y0)*st <= 0)  &&  ((-2       - y0)*st > 0) ) wConst += HygxBorder20_B0C1(t, y0);
        else if (/*(-2 - 2*t - y0)*st <= 0 */    ((-2 -   t - y0)*st > 0) ) wConst += HygxBorder30_B0C1(t, y0);
    }

    float weight = wBase - wConst * st;
    return weight;
}
#pragma endregion

// ============================================================================

#pragma region CubicStrong Hyx polynomials
// When tangent=0, i.e. exact horizontal edge. Robust against xa==xb

float HyxCell00_B0C1(float x, float y) {
    return
    (POW3(2 + x)*(2 + 3*x)*POW3(2 + y)*(2 + 3*y))/144.;
}
float HyxCell10_B0C1(float x, float y) {
    return
    -((-6 - 12*x + 8*X3 + 3*X4)*POW3(2 + y)*(2 + 3*y))/144.;
}
float HyxCell20_B0C1(float x, float y) {
    return
    ((6 + 12*x - 8*X3 + 3*X4)*POW3(2 + y)*(2 + 3*y))/144.;
}
float HyxCell30_B0C1(float x, float y) {
    return
    -((-24 + 2*POW3(-2 + x)*(-2 + 3*x))*POW3(2 + y)*(2 + 3*y))/288.;
}
float HyxCell01_B0C1(float x, float y) {
    return
    -(POW3(2 + x)*(2 + 3*x)*(-6 - 12*y + 8*Y3 + 3*Y4))/144.;
}
float HyxCell11_B0C1(float x, float y) {
    return
    ((-6 - 12*x + 8*X3 + 3*X4)*(-6 - 12*y + 8*Y3 + 3*Y4))/144.;
}
float HyxCell21_B0C1(float x, float y) {
    return
    -((6 + 12*x - 8*X3 + 3*X4)*(-6 - 12*y + 8*Y3 + 3*Y4))/144.;
}
float HyxCell31_B0C1(float x, float y) {
    return
    ((4 - 48*x + 48*X2 - 20*X3 + 3*X4)*(-6 - 12*y + 8*Y3 + 3*Y4))/144.;
}
float HyxCell02_B0C1(float x, float y) {
    return
    (POW3(2 + x)*(2 + 3*x)*(6 + 12*y - 8*Y3 + 3*Y4))/144.;
}
float HyxCell12_B0C1(float x, float y) {
    return
    -((-6 - 12*x + 8*X3 + 3*X4)*(6 + 12*y - 8*Y3 + 3*Y4))/144.;
}
float HyxCell22_B0C1(float x, float y) {
    return
    ((6 + 12*x - 8*X3 + 3*X4)*(6 + 12*y - 8*Y3 + 3*Y4))/144.;
}
float HyxCell32_B0C1(float x, float y) {
    return
    -((4 - 48*x + 48*X2 - 20*X3 + 3*X4)*(6 + 12*y - 8*Y3 + 3*Y4))/144.;
}
float HyxCell03_B0C1(float x, float y) {
    return
    -(POW3(2 + x)*(2 + 3*x)*(-24 + 2*POW3(-2 + y)*(-2 + 3*y)))/288.;
}
float HyxCell13_B0C1(float x, float y) {
    return
    ((-6 - 12*x + 8*X3 + 3*X4)*(4 - 48*y + 48*Y2 - 20*Y3 + 3*Y4))/144.;
}
float HyxCell23_B0C1(float x, float y) {
    return
    -((6 + 12*x - 8*X3 + 3*X4)*(4 - 48*y + 48*Y2 - 20*Y3 + 3*Y4))/144.;
}
float HyxCell33_B0C1(float x, float y) {
    return
    ((4 - 48*x + 48*X2 - 20*X3 + 3*X4)*(4 - 48*y + 48*Y2 - 20*Y3 + 3*Y4))/144.;
}

float Hyx_cubicB0C1(float x, float y)
{
	// globals; gives more readable cell functions and reduces redundancy
	X2 = x*x; X3 = X2*x; X4 = X3*x;
    Y2 = y*y; Y3 = Y2*y; Y4 = Y3*y;
    float w = 0;
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (y >= +1) w = HyxCell03_B0C1(x, y);
        else if (y >=  0) w = HyxCell02_B0C1(x, y);
        else if (y >= -1) w = HyxCell01_B0C1(x, y);
        else              w = HyxCell00_B0C1(x, y);
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (y >= +1) w = HyxCell13_B0C1(x, y);
        else if (y >=  0) w = HyxCell12_B0C1(x, y);
        else if (y >= -1) w = HyxCell11_B0C1(x, y);
        else              w = HyxCell10_B0C1(x, y);
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (y >= +1) w = HyxCell23_B0C1(x, y);
        else if (y >=  0) w = HyxCell22_B0C1(x, y);
        else if (y >= -1) w = HyxCell21_B0C1(x, y);
        else              w = HyxCell20_B0C1(x, y);
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (y >= +1) w = HyxCell33_B0C1(x, y);
        else if (y >=  0) w = HyxCell32_B0C1(x, y);
        else if (y >= -1) w = HyxCell31_B0C1(x, y);
        else              w = HyxCell30_B0C1(x, y);
    }
    return w;
}
#pragma endregion
