#version 330

uniform sampler2D s_texUnit;

// The 'Material' block variables are written by every call to renderSentence of VSFontLib
layout (std140) uniform Material {
	vec4 diffuse;       // unused
	vec4 ambient;       // unused
	vec4 specular;      // unused
	vec4 emissive;      // used for font color
	float shininess;    // unused
	int texCount;       // will be 1 since there is 1 font texture
};

in Data {
	vec4 v_texCoord;
} DataIn;


layout (location = 0) out vec4 outputFontShader;

void main()
{
	outputFontShader = texture(s_texUnit, DataIn.v_texCoord.xy) * emissive;
} 
